/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathBuilder
extends AbstractLogEnabled {
    public Collection<File> buildClasspathList(MavenProject project, String scope, GwtRuntime runtime, Set<Artifact> artifacts) throws MojoExecutionException {
        this.getLogger().info("establishing classpath list (scope = " + scope + ")");
        LinkedHashSet<File> items = new LinkedHashSet<File>();
        this.addSources(items, project.getCompileSourceRoots());
        this.addResources(items, project.getResources());
        items.add(new File(project.getBuild().getOutputDirectory()));
        if (scope.equals("test")) {
            this.addSources(items, project.getTestCompileSourceRoots());
            this.addResources(items, project.getTestResources());
            items.add(new File(project.getBuild().getTestOutputDirectory()));
            for (Artifact artifact : artifacts) {
                items.add(artifact.getFile());
            }
        } else if (scope.equals("compile")) {
            this.getLogger().debug("candidate artifacts : " + artifacts.size());
            for (Artifact artifact : artifacts) {
                String artifactScope = artifact.getScope();
                if (!"compile".equals(artifactScope) && !"provided".equals(artifactScope) && !"system".equals(artifactScope)) continue;
                items.add(artifact.getFile());
            }
        } else if (scope.equals("runtime")) {
            for (Artifact artifact : artifacts) {
                this.getLogger().debug("candidate artifact : " + artifact);
                if (artifact.getScope().equals("test") || !artifact.getArtifactHandler().isAddedToClasspath()) continue;
                items.add(artifact.getFile());
            }
        } else {
            throw new IllegalArgumentException("unsupported scope " + scope);
        }
        if (runtime != null) {
            items.add(runtime.getGwtDevJar());
        }
        this.getLogger().debug("GWT SDK execution classpath :");
        for (File f : items) {
            this.getLogger().debug("   " + f.getAbsolutePath());
        }
        return items;
    }

    public void addSourcesWithActiveProjects(MavenProject project, Collection<File> items, String scope) {
        List<Artifact> scopeArtifacts = this.getScopeArtifacts(project, scope);
        this.addSources(items, this.getSourceRoots(project, scope));
        for (Artifact artifact : scopeArtifacts) {
            String projectReferenceId = this.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            MavenProject refProject = (MavenProject)project.getProjectReferences().get(projectReferenceId);
            if (refProject == null) continue;
            this.addSources(items, this.getSourceRoots(refProject, scope));
        }
    }

    public void addResourcesWithActiveProjects(MavenProject project, Collection<File> items, String scope) {
        List<Artifact> scopeArtifacts = this.getScopeArtifacts(project, scope);
        this.addResources(items, this.getResources(project, scope));
        for (Artifact artifact : scopeArtifacts) {
            String projectReferenceId = this.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            MavenProject refProject = (MavenProject)project.getProjectReferences().get(projectReferenceId);
            if (refProject == null) continue;
            this.addResources(items, this.getResources(refProject, scope));
        }
    }

    private List<Artifact> getScopeArtifacts(MavenProject project, String scope) {
        if ("compile".equals(scope)) {
            return project.getCompileArtifacts();
        }
        if ("runtime".equals(scope)) {
            return project.getRuntimeArtifacts();
        }
        if ("test".equals(scope)) {
            return project.getTestArtifacts();
        }
        throw new RuntimeException("Not allowed scope " + scope);
    }

    private List<String> getSourceRoots(MavenProject project, String scope) {
        if ("compile".equals(scope) || "runtime".equals(scope)) {
            return project.getCompileSourceRoots();
        }
        if ("test".equals(scope)) {
            ArrayList<String> sourceRoots = new ArrayList<String>();
            sourceRoots.addAll(project.getTestCompileSourceRoots());
            sourceRoots.addAll(project.getCompileSourceRoots());
            return sourceRoots;
        }
        throw new RuntimeException("Not allowed scope " + scope);
    }

    private List<Resource> getResources(MavenProject project, String scope) {
        if ("compile".equals(scope) || "runtime".equals(scope)) {
            return project.getResources();
        }
        if ("test".equals(scope)) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(project.getTestResources());
            resources.addAll(project.getResources());
            return resources;
        }
        throw new RuntimeException("Not allowed scope " + scope);
    }

    private void addSources(Collection<File> items, Collection<String> sourceRoots) {
        for (String path : sourceRoots) {
            items.add(new File(path));
        }
    }

    private void addResources(Collection<File> items, Collection<Resource> resources) {
        for (Resource resource : resources) {
            items.add(new File(resource.getDirectory()));
        }
    }

    private String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

