/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.GwtModule;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.GwtVersion;
import org.codehaus.mojo.gwt.shell.AbstractGwtShellMojo;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.StringUtils;

public class CompileMojo
extends AbstractGwtShellMojo {
    private boolean skip;
    private boolean force;
    private int localWorkers;
    private boolean enableAssertions;
    private String soyc;
    private String[] compileSourcesArtifacts;
    private boolean treeLogger;
    private boolean disableClassMetadata;
    private boolean disableCastChecking;
    private boolean validateOnly;
    private boolean draftCompile;
    private File extra;

    public void doExecute(GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        if (this.skip || "pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"GWT compilation is skipped");
            return;
        }
        if (!this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        String[] modules = this.getModules();
        if (runtime.getVersion().supportMultiModuleCompile()) {
            this.compile(runtime, modules);
        } else {
            for (String module : modules) {
                this.compile(runtime, new String[]{module});
            }
        }
    }

    private void compile(GwtRuntime runtime, String[] modules) throws MojoExecutionException {
        boolean upToDate = true;
        GwtVersion gwtVersion = runtime.getVersion();
        String clazz = gwtVersion.getCompilerFQCN();
        AbstractGwtShellMojo.JavaCommand cmd = new AbstractGwtShellMojo.JavaCommand(clazz, runtime).withinScope("compile").arg("-gen").arg(this.getGen().getAbsolutePath()).arg("-logLevel").arg(this.getLogLevel()).arg("-style").arg(this.getStyle()).arg(this.enableAssertions, "-ea").arg(gwtVersion.getWebOutputArgument()).arg(this.getOutputDirectory().getAbsolutePath());
        this.addCompileSourceArtifacts(cmd);
        if (gwtVersion.supportParallelCompile()) {
            cmd.arg("-localWorkers").arg(String.valueOf(this.getLocalWorkers()));
        }
        this.addSOYC(gwtVersion, cmd);
        this.addAvancedOptions(gwtVersion, cmd);
        for (String target : modules) {
            if (!this.compilationRequired(target, this.getOutputDirectory())) continue;
            cmd.arg(target);
            upToDate = false;
        }
        if (!upToDate) {
            cmd.execute();
        }
    }

    private void addCompileSourceArtifacts(AbstractGwtShellMojo.JavaCommand cmd) throws MojoExecutionException {
        if (this.compileSourcesArtifacts == null) {
            return;
        }
        for (String include : this.compileSourcesArtifacts) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(Arrays.asList(include.split(":")));
            if (parts.size() == 2) {
                parts.add("jar");
            }
            String dependencyId = StringUtils.join(parts.iterator(), (String)":");
            boolean found = false;
            for (Artifact artifact : this.getProjectArtifacts()) {
                this.getLog().debug((CharSequence)("compare " + dependencyId + " with " + artifact.getDependencyConflictId()));
                if (!artifact.getDependencyConflictId().equals(dependencyId)) continue;
                this.getLog().debug((CharSequence)("Add " + dependencyId + " sources.jar artifact to compile classpath"));
                Artifact sources = this.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "sources");
                cmd.withinClasspath(sources.getFile());
                found = true;
                break;
            }
            if (found) continue;
            this.getLog().warn((CharSequence)("Declared compileSourcesArtifact was not found in project dependencies " + dependencyId));
        }
    }

    private void addSOYC(GwtVersion gwtVersion, AbstractGwtShellMojo.JavaCommand cmd) {
        if (gwtVersion.supportSOYC()) {
            if (this.soyc != null && !Boolean.valueOf(this.soyc).booleanValue()) {
                this.getLog().debug((CharSequence)"SOYC has been disabled by user");
            } else {
                cmd.arg("-soyc").arg("-extra").arg(this.extra.getAbsolutePath());
                this.extra.mkdirs();
            }
        }
    }

    private void addAvancedOptions(GwtVersion gwtVersion, AbstractGwtShellMojo.JavaCommand cmd) {
        if (gwtVersion.compareTo(GwtVersion.TWO_DOT_ZERO) >= 0) {
            cmd.arg(this.draftCompile, "-draftCompile").arg(this.validateOnly, "-validateOnly").arg(this.treeLogger, "-treeLogger").arg(this.disableClassMetadata, "-XdisableClassMetadata").arg(this.disableCastChecking, "-XdisableCastChecking");
        }
    }

    private int getLocalWorkers() {
        if (this.localWorkers > 0) {
            return this.localWorkers;
        }
        if (System.getProperty("java.vendor").startsWith("IBM")) {
            this.getLog().info((CharSequence)"Build is using IBM JDK, localWorkers set to 1 as workaround to gwt#4031");
            return 1;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    private boolean compilationRequired(String module, File output) throws MojoExecutionException {
        GwtModule gwtModule = this.readModule(module);
        if (gwtModule.getEntryPoints().size() == 0) {
            this.getLog().debug((CharSequence)(gwtModule.getName() + " has no EntryPoint - compilation skipped"));
            return false;
        }
        if (this.force) {
            return true;
        }
        String modulePath = gwtModule.getPath();
        String outputTarget = modulePath + "/" + modulePath + ".nocache.js";
        if (!new File(output, outputTarget).exists()) {
            return true;
        }
        SingleTargetSourceMapping singleTargetMapping = new SingleTargetSourceMapping(".java", outputTarget);
        StaleSourceScanner scanner = new StaleSourceScanner();
        scanner.addSourceMapping((SourceMapping)singleTargetMapping);
        SingleTargetSourceMapping gwtModuleMapping = new SingleTargetSourceMapping(".gwt.xml", outputTarget);
        scanner.addSourceMapping((SourceMapping)gwtModuleMapping);
        HashSet<File> compileSourceRoots = new HashSet<File>();
        this.classpathBuilder.addSourcesWithActiveProjects(this.getProject(), compileSourceRoots, "compile");
        this.classpathBuilder.addResourcesWithActiveProjects(this.getProject(), compileSourceRoots, "compile");
        for (File sourceRoot : compileSourceRoots) {
            if (!sourceRoot.isDirectory()) continue;
            try {
                if (scanner.getIncludedSources(sourceRoot, output).isEmpty()) continue;
                this.getLog().debug((CharSequence)("found stale source in " + sourceRoot + " compared with " + output));
                return true;
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)(module + " is up to date. GWT compilation skipped"));
        return false;
    }
}

