/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.shell;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.report.ReporterManager;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.AbstractGwtShellMojo;
import org.codehaus.mojo.gwt.shell.ForkedProcessExecutionException;
import org.codehaus.mojo.gwt.test.MavenTestRunner;
import org.codehaus.mojo.gwt.test.TestTemplate;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractGwtShellMojo {
    private boolean skipTests;
    private boolean skipExec;
    private boolean skip;
    private boolean testFailureIgnore;
    private String out;
    private boolean webMode;
    private boolean productionMode;
    private boolean manualMode;
    private int testTimeOut;
    protected String includes;
    protected String excludes;
    private File reportsDirectory;
    private int failures;

    @Override
    protected void doExecute(final GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipExec) {
            return;
        }
        new TestTemplate(this.getProject(), this.includes, this.excludes, new TestTemplate.CallBack(){

            public void doWithTest(File sourceDir, String test) throws MojoExecutionException {
                TestMojo.this.forkToRunTest(test, runtime);
            }
        });
        if (this.failures > 0) {
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)("There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results."));
            } else {
                throw new MojoExecutionException("There was test failures.");
            }
        }
    }

    private void forkToRunTest(String test, GwtRuntime runtime) throws MojoExecutionException {
        test = test.substring(0, test.length() - 5);
        test = StringUtils.replace((String)test, (String)File.separator, (String)".");
        try {
            new File(this.getProject().getBasedir(), this.out).mkdirs();
            try {
                new AbstractGwtShellMojo.JavaCommand(this, MavenTestRunner.class.getName(), runtime).withinScope("test").arg(test).systemProperty("surefire.reports", this.reportsDirectory.getAbsolutePath()).systemProperty("gwt.args", this.getGwtArgs()).execute();
            }
            catch (ForkedProcessExecutionException e) {
                ++this.failures;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run GWT tests", e);
        }
    }

    protected String getGwtArgs() {
        StringBuilder sb = new StringBuilder();
        sb.append("-out ").append(this.out).append(" ");
        if (this.webMode) {
            sb.append("-web ");
        }
        if (this.productionMode) {
            sb.append("-prod ");
        }
        if (this.manualMode) {
            sb.append("-runStyle Manual:1 ");
        }
        return sb.toString();
    }

    @Override
    protected void postProcessClassPath(Collection<File> classpath) {
        classpath.add(this.getClassPathElementFor(TestMojo.class));
        classpath.add(this.getClassPathElementFor(ReporterManager.class));
    }

    private File getClassPathElementFor(Class<?> clazz) {
        URL url;
        String path;
        String classFile = clazz.getName().replace('.', '/') + ".class";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((path = (path = (url = cl.getResource(classFile)).toString()).startsWith("jar:") ? path.substring(4, path.indexOf("!")) : path.substring(0, path.length() - classFile.length())).startsWith("file:")) {
            path = path.substring(5);
        }
        return new File(path);
    }

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        this.getLog().debug((CharSequence)"AbstractMojo#getProjectClassLoader()");
        List compile = this.getProject().getCompileClasspathElements();
        URL[] urls = new URL[compile.size()];
        int i = 0;
        for (Object object : compile) {
            urls[i] = object instanceof Artifact ? ((Artifact)object).getFile().toURI().toURL() : new File((String)object).toURI().toURL();
            ++i;
        }
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    @Override
    protected void addCompileSourceRoot(File path) {
        this.getProject().addCompileSourceRoot(path.getAbsolutePath());
    }

    protected URL[] addProjectClasspathElements(URL[] originalUrls) throws MojoExecutionException {
        List sources = this.getProject().getCompileSourceRoots();
        List resources = this.getProject().getResources();
        Set dependencies = this.getProject().getArtifacts();
        URL[] urls = new URL[originalUrls.length + sources.size() + resources.size() + dependencies.size() + 2];
        int i = originalUrls.length;
        this.getLog().debug((CharSequence)("add compile source roots to GWTCompiler classpath " + sources.size()));
        i = this.addClasspathElements(sources, urls, i);
        this.getLog().debug((CharSequence)("add resources to GWTCompiler classpath " + resources.size()));
        i = this.addClasspathElements(resources, urls, i);
        this.getLog().debug((CharSequence)("add project dependencies to GWTCompiler  classpath " + dependencies.size()));
        i = this.addClasspathElements(dependencies, urls, i);
        try {
            urls[i++] = this.getGenerateDirectory().toURI().toURL();
            urls[i] = new File(this.getProject().getBuild().getOutputDirectory()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to convert project.build.outputDirectory to URL", (Exception)e);
        }
        return urls;
    }

    protected ClassLoader getClassLoader(GwtRuntime runtime) throws MojoExecutionException {
        try {
            Collection<File> classpath = this.getClasspath("compile", runtime);
            URL[] urls = new URL[classpath.size()];
            int i = 0;
            for (File file : classpath) {
                urls[i++] = file.toURI().toURL();
            }
            ClassLoader parent = this.getClass().getClassLoader();
            return new URLClassLoader(urls, parent.getParent());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to resolve project dependencies");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unexpecetd internal error");
        }
    }

    public void setTestTimeOut(int testTimeOut) {
        this.setTimeOut(testTimeOut);
    }
}

