/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.webxml;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.gwt.webxml.ServletDescriptor;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtWebInfProcessor {
    private static final String[] BEFORE_SERVLETS = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    private static final String[] AFTER_SERVLETS = new String[]{"servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib", "resource-env-ref", "resource-ref", "security-constraint", "login-config", "security-role", "env-entry", "ejb-ref", "ejb-local-ref"};
    private static final String[] BEFORE_MAPPINGS = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    private static final String[] AFTER_MAPPINGS = new String[]{"session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib", "resource-env-ref", "resource-ref", "security-constraint", "login-config", "security-role", "env-entry", "ejb-ref", "ejb-local-ref"};

    public void process(File webXml, Collection<ServletDescriptor> servletDescriptors) throws Exception {
        this.process(webXml, webXml, servletDescriptors);
    }

    public void process(File sourceWebXml, File mergeWebXml, Collection<ServletDescriptor> servletDescriptors) throws Exception {
        Document dom = this.insertServlets(sourceWebXml, servletDescriptors);
        XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)mergeWebXml);
        xmlOut.output(dom, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private Document insertServlets(File webXml, Collection<ServletDescriptor> servletDescriptors) throws JDOMException, IOException {
        Document dom = this.getWebXmlAsDocument(webXml);
        Element webapp = dom.getRootElement();
        Namespace ns = webapp.getNamespace();
        int insertAfter = this.getInsertPosition(webapp, BEFORE_SERVLETS, AFTER_SERVLETS);
        Iterator<ServletDescriptor> it = servletDescriptors.iterator();
        while (it.hasNext()) {
            ServletDescriptor d = it.next();
            XPath path = XPath.newInstance((String)("/web-app/servlet/servlet-name[text() = '" + d.getName() + "']"));
            if (path.selectNodes((Object)dom).size() > 0) {
                it.remove();
                continue;
            }
            ++insertAfter;
            Element servlet = new Element("servlet", ns);
            Element servletName = new Element("servlet-name", ns);
            servletName.setText(d.getName());
            servlet.addContent((Content)servletName);
            Element servletClass = new Element("servlet-class", ns);
            servletClass.setText(d.getClassName());
            servlet.addContent((Content)servletClass);
            webapp.addContent(insertAfter, (Content)servlet);
        }
        insertAfter = this.getInsertPosition(webapp, BEFORE_MAPPINGS, AFTER_MAPPINGS);
        for (ServletDescriptor d : servletDescriptors) {
            ++insertAfter;
            Element servletMapping = new Element("servlet-mapping", ns);
            Element servletName = new Element("servlet-name", ns);
            servletName.setText(d.getName());
            servletMapping.addContent((Content)servletName);
            Element urlPattern = new Element("url-pattern", ns);
            String path = d.getPath();
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
            urlPattern.setText(path);
            servletMapping.addContent((Content)urlPattern);
            webapp.addContent(insertAfter, (Content)servletMapping);
        }
        return dom;
    }

    private int getInsertPosition(Element webapp, String[] startAfter, String[] stopBefore) throws JDOMException, IOException {
        int i;
        List children = webapp.getContent();
        Comment insertAfter = new Comment("inserted by gwt-maven-plugin");
        ArrayList<String> namesBefore = new ArrayList<String>();
        ArrayList<String> namesAfter = new ArrayList<String>();
        for (i = 0; i < startAfter.length; ++i) {
            namesBefore.add(startAfter[i]);
        }
        for (i = 0; i < stopBefore.length; ++i) {
            namesAfter.add(stopBefore[i]);
        }
        if (children == null || children.size() == 0) {
            webapp.addContent((Content)insertAfter);
        } else {
            boolean foundPoint = false;
            for (int i2 = 0; !foundPoint && i2 < children.size(); ++i2) {
                Object o = children.get(i2);
                if (!(o instanceof Element)) continue;
                Element child = (Element)o;
                if (namesAfter.contains(child.getName())) {
                    webapp.addContent(i2, (Content)insertAfter);
                    foundPoint = true;
                    break;
                }
                if (namesBefore.contains(child.getName())) continue;
                webapp.addContent(i2 + 1, (Content)insertAfter);
                foundPoint = true;
                break;
            }
            if (!foundPoint) {
                webapp.addContent((Content)insertAfter);
            }
        }
        return webapp.indexOf((Content)insertAfter);
    }

    private Document getWebXmlAsDocument(File webXml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return builder.build(webXml.toURI().toURL());
    }
}

