/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.webxml;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.mojo.gwt.GwtModule;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.AbstractGwtWebMojo;
import org.codehaus.mojo.gwt.webxml.GwtWebInfProcessor;
import org.codehaus.mojo.gwt.webxml.ServletDescriptor;

public class MergeWebXmlMojo
extends AbstractGwtWebMojo {
    private Set<String> checkedModules = new HashSet<String>();
    private File mergedWebXml;

    public void doExecute(GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.mergedWebXml.exists()) {
                this.mergedWebXml.getParentFile().mkdirs();
                this.mergedWebXml.createNewFile();
            }
            FileUtils.copyFile((File)this.getWebXml(), (File)this.mergedWebXml);
            LinkedHashSet<ServletDescriptor> servlets = new LinkedHashSet<ServletDescriptor>();
            for (String module : this.getModules()) {
                GwtModule gwtModule = this.readModule(module);
                Map<String, String> moduleServlets = gwtModule.getServlets();
                this.getLog().debug((CharSequence)("merge " + moduleServlets.size() + " servlets from module " + module));
                for (Map.Entry<String, String> servlet : moduleServlets.entrySet()) {
                    servlets.add(new ServletDescriptor(servlet.getKey(), servlet.getValue()));
                }
            }
            new GwtWebInfProcessor().process(this.mergedWebXml, this.mergedWebXml, servlets);
            this.getLog().info((CharSequence)(servlets.size() + " servlet(s) merged into " + this.mergedWebXml));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to merge web.xml", e);
        }
    }

    protected ClassLoader fixThreadClasspath(GwtRuntime runtime) {
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("gwt-plugin", Thread.currentThread().getContextClassLoader());
            ClassRealm realm = root.createChildRealm("gwt-project");
            Collection<File> classpath = this.classpathBuilder.buildClasspathList(this.getProject(), "compile", runtime, this.getProjectArtifacts());
            Iterator<File> it = classpath.iterator();
            while (it.hasNext()) {
                realm.addConstituent(it.next().toURI().toURL());
            }
            Thread.currentThread().setContextClassLoader(realm.getClassLoader());
            return realm.getClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

