/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import EDU.purdue.jtb.JTB;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class JTBMojo
extends AbstractMojo {
    private String packageName;
    private String packagePath;
    private String nodePackageName;
    private String nodePackagePath;
    private String visitorPackageName;
    private String visitorPackagePath;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;
    private String sourceDirectory;
    private String outputDirectory;
    private String timestampDirectory;
    private int staleMillis;
    private MavenProject project;
    private File baseDir;

    public void execute() throws MojoExecutionException {
        Set staleGrammars;
        if (this.packageName != null) {
            this.packagePath = StringUtils.replace((String)this.packageName, (char)'.', (char)File.separatorChar);
            this.getLog().debug((CharSequence)("Using packagePath: " + this.packagePath));
        } else {
            if (this.visitorPackageName != null) {
                this.visitorPackagePath = StringUtils.replace((String)this.visitorPackageName, (char)'.', (char)File.separatorChar);
                this.getLog().debug((CharSequence)("Using visitorPackagePath: " + this.visitorPackagePath));
            }
            if (this.nodePackageName != null) {
                this.nodePackagePath = StringUtils.replace((String)this.nodePackageName, (char)'.', (char)File.separatorChar);
                this.getLog().debug((CharSequence)("Using nodePackagePath: " + this.nodePackagePath));
            }
        }
        if (!FileUtils.fileExists((String)this.outputDirectory)) {
            FileUtils.mkdir((String)this.outputDirectory);
        }
        if (!FileUtils.fileExists((String)this.timestampDirectory)) {
            FileUtils.mkdir((String)this.timestampDirectory);
        }
        if ((staleGrammars = this.computeStaleGrammars()).isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all grammars are up to date");
            if (this.project != null) {
                this.project.addCompileSourceRoot(this.outputDirectory);
            }
            return;
        }
        Iterator i = staleGrammars.iterator();
        while (i.hasNext()) {
            File jtbFile = (File)i.next();
            try {
                File newDir;
                File tempDir;
                JTB.main((String[])this.generateJTBArgumentList(jtbFile.getAbsolutePath()));
                if (this.packagePath != null) {
                    tempDir = new File(this.baseDir, "syntaxtree");
                    newDir = new File(this.outputDirectory + File.separator + this.packagePath + File.separator + "syntaxtree");
                    newDir.mkdirs();
                    this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                    tempDir.renameTo(newDir);
                    tempDir = new File(this.baseDir, "visitor");
                    newDir = new File(this.outputDirectory + File.separator + this.packagePath + File.separator + "visitor");
                    newDir.mkdirs();
                    this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                    tempDir.renameTo(newDir);
                } else {
                    if (this.nodePackagePath != null) {
                        tempDir = new File(this.baseDir, this.nodePackagePath.substring(this.nodePackagePath.lastIndexOf(File.separator)));
                        newDir = new File(this.outputDirectory + File.separator + this.nodePackagePath);
                        newDir.mkdirs();
                        this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                        tempDir.renameTo(newDir);
                    } else {
                        tempDir = new File(this.baseDir, "syntaxtree");
                        newDir = new File(this.outputDirectory + File.separator + "syntaxtree");
                        newDir.mkdirs();
                        this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                        tempDir.renameTo(newDir);
                    }
                    if (this.visitorPackagePath != null) {
                        tempDir = new File(this.baseDir, this.visitorPackagePath.substring(this.visitorPackagePath.lastIndexOf(File.separator)));
                        newDir = new File(this.outputDirectory + File.separator + this.visitorPackagePath);
                        newDir.mkdirs();
                        this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                        tempDir.renameTo(newDir);
                    } else {
                        tempDir = new File(this.baseDir, "visitor");
                        newDir = new File(this.outputDirectory + File.separator + "visitor");
                        newDir.mkdirs();
                        this.getLog().debug((CharSequence)("Moving " + tempDir + " to " + newDir));
                        tempDir.renameTo(newDir);
                    }
                }
                FileUtils.copyFileToDirectory((File)jtbFile, (File)new File(this.timestampDirectory));
            }
            catch (Exception e) {
                throw new MojoExecutionException("JTB execution failed", e);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    private String[] generateJTBArgumentList(String jtbFileName) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-o");
        argsList.add(this.outputDirectory + File.separator + FileUtils.basename((String)jtbFileName) + "jj");
        if (this.packageName != null) {
            argsList.add("-p");
            argsList.add(this.packageName);
        } else {
            if (this.nodePackageName != null) {
                argsList.add("-np");
                argsList.add(this.nodePackageName);
            }
            if (this.visitorPackageName != null) {
                argsList.add("-vp");
                argsList.add(this.visitorPackageName);
            }
        }
        if (this.supressErrorChecking != null && this.supressErrorChecking.booleanValue()) {
            argsList.add("-e");
        }
        if (this.javadocFriendlyComments != null && this.javadocFriendlyComments.booleanValue()) {
            argsList.add("-jd");
        }
        if (this.descriptiveFieldNames != null && this.descriptiveFieldNames.booleanValue()) {
            argsList.add("-f");
        }
        if (this.nodeParentClass != null) {
            argsList.add("-ns");
            argsList.add(this.nodeParentClass);
        }
        if (this.parentPointers != null && this.parentPointers.booleanValue()) {
            argsList.add("-pp");
        }
        if (this.specialTokens != null && this.specialTokens.booleanValue()) {
            argsList.add("-tk");
        }
        if (this.scheme != null && this.scheme.booleanValue()) {
            argsList.add("-scheme");
        }
        if (this.printer != null && this.printer.booleanValue()) {
            argsList.add("-printer");
        }
        argsList.add(jtbFileName);
        this.getLog().debug((CharSequence)("Using arguments: " + argsList));
        return argsList.toArray(new String[argsList.size()]);
    }

    private Set computeStaleGrammars() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".jtb", ".jtb");
        SuffixMapping mappingCAP = new SuffixMapping(".JTB", ".JTB");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        File outDir = new File(this.timestampDirectory);
        HashSet staleSources = new HashSet();
        File sourceDir = new File(this.sourceDirectory);
        try {
            staleSources.addAll(scanner.getIncludedSources(sourceDir, outDir));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }
}

