/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JTB;
import org.codehaus.mojo.javacc.JavaCC;

public class JTBJavaCCMojo
extends AbstractJavaCCMojo {
    private String packageName;
    private String nodePackageName;
    private String visitorPackageName;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;
    private File sourceDirectory;
    private File interimDirectory;
    private File outputDirectory;
    private String[] includes;
    private String[] excludes;
    private int staleMillis;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jtb", "**/*.JTB"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File tempDirectory;
        File jtbFile = grammarInfo.getGrammarFile();
        File jtbDirectory = jtbFile.getParentFile();
        File jjDirectory = tempDirectory = this.getTempDirectory();
        String nodePackage = grammarInfo.resolvePackageName(this.getNodePackageName());
        File nodeDirectory = new File(tempDirectory, "node");
        String visitorPackage = grammarInfo.resolvePackageName(this.getVisitorPackageName());
        File visitorDirectory = new File(tempDirectory, "visitor");
        File parserDirectory = new File(tempDirectory, "parser");
        JTB jtb = this.newJTB();
        jtb.setInputFile(jtbFile);
        jtb.setOutputDirectory(jjDirectory);
        jtb.setNodeDirectory(nodeDirectory);
        jtb.setVisitorDirectory(visitorDirectory);
        jtb.setNodePackageName(nodePackage);
        jtb.setVisitorPackageName(visitorPackage);
        jtb.run();
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jtb.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
        this.copyGrammarOutput(this.getInterimDirectory(), nodePackage, nodeDirectory, "!Node*");
        this.copyGrammarOutput(this.getInterimDirectory(), visitorPackage, visitorDirectory, "");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), parserDirectory, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), jtbDirectory, "*");
        }
        this.deleteTempDirectory(tempDirectory);
    }

    private String getNodePackageName() {
        if (this.packageName != null) {
            return this.packageName + ".syntaxtree";
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return "*.syntaxtree";
    }

    private String getVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName + ".visitor";
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return "*.visitor";
    }

    private JTB newJTB() {
        JTB jtb = new JTB();
        jtb.setLog(this.getLog());
        jtb.setDescriptiveFieldNames(this.descriptiveFieldNames);
        jtb.setJavadocFriendlyComments(this.javadocFriendlyComments);
        jtb.setNodeParentClass(this.nodeParentClass);
        jtb.setParentPointers(this.parentPointers);
        jtb.setPrinter(this.printer);
        jtb.setScheme(this.scheme);
        jtb.setSpecialTokens(this.specialTokens);
        jtb.setSupressErrorChecking(this.supressErrorChecking);
        return jtb;
    }
}

