/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.javancss.AbstractNcssReportGenerator;
import org.codehaus.mojo.javancss.ModuleReport;
import org.dom4j.Document;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NcssAggregateReportGenerator
extends AbstractNcssReportGenerator {
    public NcssAggregateReportGenerator(Sink sink, ResourceBundle bundle, Log log) {
        super(sink, bundle, log);
    }

    public void doReport(Locale locale, List<ModuleReport> moduleReports, int lineThreshold) {
        this.getSink().head();
        this.getSink().title();
        this.getSink().text(this.getString("report.javancss.title"));
        this.getSink().title_();
        this.getSink().head_();
        this.getSink().body();
        this.doIntro(false);
        this.startSection("report.javancss.module.link", "report.javancss.module.title");
        this.doModuleAnalysis(moduleReports);
        this.endSection();
        this.getSink().body_();
        this.getSink().close();
    }

    private void doModuleAnalysis(List<ModuleReport> reports) {
        this.getSink().table();
        this.getSink().tableRow();
        this.headerCellHelper(this.getString("report.javancss.header.module"));
        this.headerCellHelper(this.getString("report.javancss.header.packages"));
        this.headerCellHelper(this.getString("report.javancss.header.classetotal"));
        this.headerCellHelper(this.getString("report.javancss.header.functiontotal"));
        this.headerCellHelper(this.getString("report.javancss.header.ncsstotal"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc"));
        this.headerCellHelper(this.getString("report.javancss.header.javadoc_line"));
        this.headerCellHelper(this.getString("report.javancss.header.single_comment"));
        this.headerCellHelper(this.getString("report.javancss.header.multi_comment"));
        this.getSink().tableRow_();
        int packages = 0;
        int classes = 0;
        int methods = 0;
        int ncss = 0;
        int javadocs = 0;
        int jdlines = 0;
        int single = 0;
        int multi = 0;
        for (ModuleReport report : reports) {
            Document document = report.getJavancssDocument();
            this.getSink().tableRow();
            this.getLog().debug((CharSequence)("Aggregating " + report.getModule().getArtifactId()));
            this.tableCellHelper(report.getModule().getArtifactId());
            int packageSize = document.selectNodes("//javancss/packages/package").size();
            packages += packageSize;
            this.tableCellHelper(String.valueOf(packageSize));
            Node node = document.selectSingleNode("//javancss/packages/total");
            String classSize = node.valueOf("classes");
            this.tableCellHelper(classSize);
            classes += Integer.parseInt(classSize);
            String methodSize = node.valueOf("functions");
            this.tableCellHelper(methodSize);
            methods += Integer.parseInt(methodSize);
            String ncssSize = node.valueOf("ncss");
            this.tableCellHelper(ncssSize);
            ncss += Integer.parseInt(ncssSize);
            String javadocSize = node.valueOf("javadocs");
            this.tableCellHelper(javadocSize);
            javadocs += Integer.parseInt(javadocSize);
            String jdlineSize = node.valueOf("javadoc_lines");
            this.tableCellHelper(jdlineSize);
            jdlines += Integer.parseInt(jdlineSize);
            String singleSize = node.valueOf("single_comment_lines");
            this.tableCellHelper(singleSize);
            single += Integer.parseInt(singleSize);
            String multiSize = node.valueOf("multi_comment_lines");
            this.tableCellHelper(multiSize);
            multi += Integer.parseInt(multiSize);
            this.getSink().tableRow_();
        }
        this.getSink().tableRow();
        this.tableCellHelper(this.getString("report.javancss.header.totals"));
        this.tableCellHelper(String.valueOf(packages));
        this.tableCellHelper(String.valueOf(classes));
        this.tableCellHelper(String.valueOf(methods));
        this.tableCellHelper(String.valueOf(ncss));
        this.tableCellHelper(String.valueOf(javadocs));
        this.tableCellHelper(String.valueOf(jdlines));
        this.tableCellHelper(String.valueOf(single));
        this.tableCellHelper(String.valueOf(multi));
        this.getSink().tableRow_();
        this.getSink().table_();
    }
}

