/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javancss;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javancss.Javancss;
import javancss.parser.ParseException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;

public class NcssExecuter {
    private static final int ARG_SIZE = 8;
    private File sourceLocation;
    private String outputFilename;
    private String[] fileList;
    private String encoding = null;

    NcssExecuter() {
        this.sourceLocation = null;
        this.outputFilename = null;
        this.fileList = null;
    }

    public NcssExecuter(File sourceDirectory, String outputFilename) {
        this.sourceLocation = sourceDirectory;
        this.outputFilename = outputFilename;
        this.fileList = null;
    }

    public NcssExecuter(String[] fileList, String outputFilename) {
        this.sourceLocation = null;
        this.fileList = fileList;
        this.outputFilename = outputFilename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void execute() throws MavenReportException {
        try {
            Javancss javancss = new Javancss(this.getCommandLineArgument());
            Throwable ncssThrow = javancss.getLastError();
            if (ncssThrow != null) {
                String lastErrorMessage = this.limit(javancss.getLastErrorMessage(), 3);
                if (ncssThrow instanceof ParseException) {
                    throw new MavenReportException("Parsing error while executing JavaNCSS " + NcssExecuter.getJavaNCSSVersion() + " " + lastErrorMessage, (Exception)ncssThrow);
                }
                Exception e = ncssThrow instanceof Exception ? (Exception)ncssThrow : new Exception(ncssThrow);
                throw new MavenReportException("Unexpected error while executing JavaNCSS " + NcssExecuter.getJavaNCSSVersion() + " " + lastErrorMessage, e);
            }
        }
        catch (IOException ioe) {
            throw new MavenReportException("IO Error while executing JavaNCSS " + NcssExecuter.getJavaNCSSVersion(), (Exception)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String limit(String source, int lines) {
        BufferedReader reader = new BufferedReader(new StringReader(source));
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < lines; ++i) {
                String line = reader.readLine();
                if (line == null) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return sb.toString();
    }

    private String[] getCommandLineArgument() {
        ArrayList<String> argumentList = new ArrayList<String>(8);
        argumentList.add("-package");
        argumentList.add("-object");
        argumentList.add("-function");
        argumentList.add("-xml");
        argumentList.add("-recursive");
        argumentList.add("-out");
        argumentList.add(this.outputFilename);
        if (this.encoding != null) {
            argumentList.add("-encoding");
            argumentList.add(this.encoding);
        }
        if (this.sourceLocation != null && this.sourceLocation.isDirectory()) {
            argumentList.add(this.sourceLocation.getAbsolutePath());
        } else {
            for (int i = 0; i < this.fileList.length; ++i) {
                argumentList.add(this.fileList[i]);
            }
        }
        return argumentList.toArray(new String[argumentList.size()]);
    }

    public static String getJavaNCSSVersion() {
        String version;
        Package p = Javancss.class.getPackage();
        String string = version = p == null ? null : p.getSpecificationVersion();
        if (version == null) {
            version = "unknown";
        }
        return version;
    }
}

