/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurer
extends AbstractMavenLifecycleParticipant {
    private String htmlResourceDir;
    private String htmlResourceExcludes;
    private String htmlTestResourceDir;
    private String htmlTestResourceExcludes;
    private String jsResourceDir;
    private String jsResourceExcludes;
    private String jsTestResourceDir;
    private String jsTestResourceExcludes;
    private Plugin jettyPlugin;
    private String jettyContextPath;
    private List<String> jettyResourceBases;
    private Plugin mavenCompilerPlugin;
    private Plugin mavenSurefirePlugin;
    private Plugin mavenAssemblyPlugin;
    private Plugin mavenSitePlugin;
    private String mavenSiteExcludeModules;
    private String mavenSiteJstoolsGroup;
    private String mavenSiteJstoolsArtifact;
    private String mavenSiteJstoolsVersion;
    private String mavenSiteJstoolsReportsJsDir;
    private List<String> mavenSiteJstoolsReports;
    private Dependency almondDependency;
    private Dependency qunitDependency;
    private Dependency jstestrunnerJUnitDependency;
    private MavenProjectHelper projectHelper;
    private ArtifactHandler jsArtifactHandler;
    private ArtifactHandlerManager artifactHandlerManager;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        HashMap<String, ArtifactHandler> handlers = new HashMap<String, ArtifactHandler>(1);
        handlers.put("js", this.jsArtifactHandler);
        this.artifactHandlerManager.addHandlers(handlers);
        List projects = session.getProjects();
        for (MavenProject project : projects) {
            if (!project.getExtensionArtifactMap().containsKey("org.codehaus.mojo:javascript-maven-plugin")) continue;
            List plugins = project.getBuildPlugins();
            Set<Plugin> projectSpecifiedPlugins = this.buildSpecifiedPlugins(project);
            if (!projectSpecifiedPlugins.contains(this.jettyPlugin)) {
                plugins.remove(this.jettyPlugin);
                this.configureJetty(project);
            }
            if (!projectSpecifiedPlugins.contains(this.mavenCompilerPlugin)) {
                plugins.remove(this.mavenCompilerPlugin);
                this.configureMavenCompiler(project);
            }
            if (!projectSpecifiedPlugins.contains(this.mavenSurefirePlugin)) {
                plugins.remove(this.mavenSurefirePlugin);
                this.configureMavenSurefire(project);
            }
            if (!projectSpecifiedPlugins.contains(this.mavenSitePlugin)) {
                plugins.remove(this.mavenSitePlugin);
                this.configureMavenSite(project);
            }
            this.addResources(project);
            this.addDependencies(project);
            if (projectSpecifiedPlugins.contains(this.mavenAssemblyPlugin)) continue;
            this.addArtifacts(project);
        }
        super.afterProjectsRead(session);
    }

    protected Set<Plugin> buildSpecifiedPlugins(MavenProject project) {
        HashSet<Plugin> plugins = new HashSet<Plugin>(project.getBuildPlugins().size());
        for (MavenProject currentProject = project; currentProject != null; currentProject = currentProject.getParent()) {
            Build build = currentProject.getOriginalModel().getBuild();
            if (build == null) continue;
            plugins.addAll(build.getPlugins());
        }
        return plugins;
    }

    private void configureMavenSite(MavenProject project) {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom excludeModules = new Xpp3Dom("excludeModules");
        excludeModules.setValue(this.mavenSiteExcludeModules);
        configuration.addChild(excludeModules);
        Xpp3Dom reportPlugins = new Xpp3Dom("reportPlugins");
        configuration.addChild(reportPlugins);
        Xpp3Dom plugin = new Xpp3Dom("plugin");
        reportPlugins.addChild(plugin);
        Xpp3Dom groupId = new Xpp3Dom("groupId");
        groupId.setValue(this.mavenSiteJstoolsGroup);
        plugin.addChild(groupId);
        Xpp3Dom artifactId = new Xpp3Dom("artifactId");
        artifactId.setValue(this.mavenSiteJstoolsArtifact);
        plugin.addChild(artifactId);
        Xpp3Dom version = new Xpp3Dom("version");
        version.setValue(this.mavenSiteJstoolsVersion);
        plugin.addChild(version);
        Xpp3Dom pluginConfiguration = new Xpp3Dom("configuration");
        plugin.addChild(pluginConfiguration);
        Xpp3Dom jsDir = new Xpp3Dom("jsDir");
        jsDir.setValue(this.mavenSiteJstoolsReportsJsDir);
        pluginConfiguration.addChild(jsDir);
        Xpp3Dom reportSets = new Xpp3Dom("reportSets");
        pluginConfiguration.addChild(reportSets);
        Xpp3Dom reportSet = new Xpp3Dom("reportSet");
        reportSets.addChild(reportSet);
        if (this.mavenSiteJstoolsReports.size() > 0) {
            Xpp3Dom reports = new Xpp3Dom("reports");
            for (String reportValue : this.mavenSiteJstoolsReports) {
                Xpp3Dom report = new Xpp3Dom("report");
                report.setValue(reportValue);
                reports.addChild(report);
            }
            reportSet.addChild(reports);
        }
        this.mavenSitePlugin.setConfiguration((Object)configuration);
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("site");
        pluginExecution.setPhase("site");
        pluginExecution.setId("default-site");
        pluginExecution.setConfiguration((Object)configuration);
        pluginExecutions.add(pluginExecution);
        this.mavenSitePlugin.setExecutions(pluginExecutions);
        project.getBuildPlugins().add(this.mavenSitePlugin);
    }

    private void configureMavenSurefire(MavenProject project) {
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("test");
        pluginExecutions.add(pluginExecution);
        this.mavenSurefirePlugin.setExecutions(pluginExecutions);
        project.getBuildPlugins().add(this.mavenSurefirePlugin);
    }

    private void configureMavenCompiler(MavenProject project) {
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.setId("default-testCompile");
        pluginExecution.setPhase("test-compile");
        pluginExecution.addGoal("testCompile");
        pluginExecutions.add(pluginExecution);
        this.mavenCompilerPlugin.setExecutions(pluginExecutions);
        project.getBuildPlugins().add(this.mavenCompilerPlugin);
    }

    private void configureJetty(MavenProject project) {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom webAppConfig = new Xpp3Dom("webAppConfig");
        configuration.addChild(webAppConfig);
        Xpp3Dom contextPath = new Xpp3Dom("contextPath");
        contextPath.setValue(this.jettyContextPath);
        webAppConfig.addChild(contextPath);
        if (this.jettyResourceBases.size() > 0) {
            Xpp3Dom resourceBases = new Xpp3Dom("resourceBases");
            for (String resourceBaseValue : this.jettyResourceBases) {
                Xpp3Dom resourceBase = new Xpp3Dom("resourceBases");
                resourceBase.setValue(resourceBaseValue);
                resourceBases.addChild(resourceBase);
            }
            webAppConfig.addChild(resourceBases);
        }
        this.jettyPlugin.setConfiguration((Object)configuration);
        project.getBuildPlugins().add(this.jettyPlugin);
    }

    private void addResources(MavenProject project) {
        this.projectHelper.addResource(project, this.htmlResourceDir, null, Arrays.asList(this.htmlResourceExcludes));
        this.projectHelper.addTestResource(project, this.htmlTestResourceDir, null, Arrays.asList(this.htmlTestResourceExcludes));
        this.projectHelper.addResource(project, this.jsResourceDir, null, Arrays.asList(this.jsResourceExcludes));
        this.projectHelper.addTestResource(project, this.jsTestResourceDir, null, Arrays.asList(this.jsTestResourceExcludes));
    }

    private void addDependencies(MavenProject project) {
        List dependencies = project.getDependencies();
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>(dependencies.size());
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getGroupId() + ":" + dependency.getArtifactId(), dependency);
        }
        if (!dependencyMap.containsKey(this.almondDependency.getGroupId() + ":" + this.almondDependency.getArtifactId())) {
            dependencies.add(this.almondDependency);
        }
        if (!dependencyMap.containsKey(this.qunitDependency.getGroupId() + ":" + this.qunitDependency.getArtifactId())) {
            this.qunitDependency.setScope("test");
            dependencies.add(this.qunitDependency);
        }
        if (!dependencyMap.containsKey(this.jstestrunnerJUnitDependency.getGroupId() + ":" + this.jstestrunnerJUnitDependency.getArtifactId())) {
            this.jstestrunnerJUnitDependency.setScope("test");
            dependencies.add(this.jstestrunnerJUnitDependency);
        }
    }

    private void addArtifacts(MavenProject project) {
        File minTargetFolder = new File(project.getBasedir(), "target" + File.separator + "min" + File.separator + "classes");
        project.getArtifact().setFile(new File(minTargetFolder, "1.js"));
        this.projectHelper.attachArtifact(project, new File(minTargetFolder, "1-min.js"), "min");
    }
}

