/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public abstract class AbstractJBossServerMojo
extends AbstractMojo {
    protected String jbossHome;
    protected String serverName;
    protected String options;
    private WagonManager wagonManager;
    private String serverId;

    protected void checkConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Using JBOSS_HOME: " + this.jbossHome));
        if (this.jbossHome == null || this.jbossHome.equals("")) {
            throw new MojoExecutionException("Neither JBOSS_HOME nor the jbossHome configuration parameter is set!");
        }
    }

    protected void launch(String commandName, String params) throws MojoExecutionException {
        this.checkConfig();
        String osName = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = null;
            if (osName.startsWith("Windows")) {
                String[] command = new String[]{"cmd.exe", "/C", "cd /D " + this.jbossHome + "\\bin & set JBOSS_HOME=\"" + this.jbossHome + "\" & " + commandName + ".bat " + " " + params};
                proc = runtime.exec(command);
                this.dump(proc.getInputStream());
                this.dump(proc.getErrorStream());
            } else {
                String[] command = new String[]{"sh", "-c", "cd " + this.jbossHome + "/bin; export JBOSS_HOME=\"" + this.jbossHome + "\"; ./" + commandName + ".sh " + " " + params};
                proc = runtime.exec(command);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to execute command: " + e.getMessage(), e);
        }
    }

    protected void dump(final InputStream input) {
        int streamBufferSize = 1000;
        new Thread(new Runnable(){

            public void run() {
                try {
                    byte[] b = new byte[1000];
                    while (input.read(b) != -1) {
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public String getUsername() throws MojoExecutionException {
        if (this.serverId != null) {
            AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.serverId);
            if (info == null) {
                throw new MojoExecutionException("Server not defined in settings.xml: " + this.serverId);
            }
            return info.getUserName();
        }
        return null;
    }

    public String getPassword() throws MojoExecutionException {
        if (this.serverId != null) {
            AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.serverId);
            if (info == null) {
                throw new MojoExecutionException("Server not defined in settings.xml: " + this.serverId);
            }
            return info.getPassword();
        }
        return null;
    }
}

