/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateCertificateRequest;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generateCertificate", requiresProject=true, threadSafe=true)
public class GenerateCertificateMojo
extends AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo<KeyToolGenerateCertificateRequest> {
    @Parameter
    private String keypass;
    @Parameter
    private boolean rfc;
    @Parameter
    private File infile;
    @Parameter
    private File outfile;
    @Parameter
    private String sigalg;
    @Parameter
    private String dname;
    @Parameter
    private String startdate;
    @Deprecated
    @Parameter
    private String ext;
    @Parameter
    private List<String> exts;
    @Parameter
    private String validity;

    public GenerateCertificateMojo() {
        super(KeyToolGenerateCertificateRequest.class);
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.createParentDirIfNecessary(this.outfile.getPath());
        super.execute();
    }

    @Override
    protected KeyToolGenerateCertificateRequest createKeytoolRequest() {
        KeyToolGenerateCertificateRequest request = (KeyToolGenerateCertificateRequest)super.createKeytoolRequest();
        request.setKeypass(this.keypass);
        request.setRfc(this.rfc);
        request.setInfile(this.infile);
        request.setOutfile(this.outfile);
        request.setSigalg(this.sigalg);
        request.setDname(this.dname);
        request.setStartdate(this.startdate);
        if (this.exts != null && !this.exts.isEmpty()) {
            request.setExts(this.exts);
        } else {
            request.setExt(this.ext);
        }
        request.setValidity(this.validity);
        return request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        return commandLineInfo;
    }
}

