/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.spdx;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.codehaus.mojo.license.spdx.SpdxLicenseInfo;
import org.codehaus.mojo.license.spdx.SpdxLicenseListData;

public class SpdxLicenseList {
    private static volatile SpdxLicenseList latest;
    private static final Object LOCK;
    private final String licenseListVersion;
    private final String releaseDate;
    private final Map<String, SpdxLicenseInfo> licenses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpdxLicenseList getLatest() {
        if (latest == null) {
            Object object = LOCK;
            synchronized (object) {
                if (latest == null) {
                    latest = SpdxLicenseListData.createList();
                }
            }
        }
        return latest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SpdxLicenseList(String licenseListVersion, Map<String, SpdxLicenseInfo> licenses, String releaseDate) {
        this.licenseListVersion = licenseListVersion;
        this.licenses = licenses;
        this.releaseDate = releaseDate;
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public Map<String, SpdxLicenseInfo> getLicenses() {
        return this.licenses;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    static {
        LOCK = new Object();
    }

    public static class Builder {
        private String licenseListVersion;
        private String releaseDate;
        private Map<String, SpdxLicenseInfo> licenses = new LinkedHashMap<String, SpdxLicenseInfo>();

        public SpdxLicenseList build() {
            Objects.requireNonNull(this.licenseListVersion, "isDeprecatedLicenseId");
            Objects.requireNonNull(this.releaseDate, "detailsUrl");
            if (this.licenses.isEmpty()) {
                throw new IllegalStateException("licenses cannot be empty");
            }
            Map<String, SpdxLicenseInfo> lics = Collections.unmodifiableMap(this.licenses);
            this.licenses = null;
            return new SpdxLicenseList(this.licenseListVersion, lics, this.releaseDate);
        }

        public Builder licenseListVersion(String licenseListVersion) {
            this.licenseListVersion = licenseListVersion;
            return this;
        }

        public Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder license(SpdxLicenseInfo license) {
            this.licenses.put(license.getLicenseId(), license);
            return this;
        }
    }
}

