/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.license.download.ProjectLicense;

public class ProjectLicenseInfo {
    private String groupId;
    private String artifactId;
    private String version;
    private List<ProjectLicense> licenses = new ArrayList<ProjectLicense>();
    private List<ProjectLicense> matchLicenses = new ArrayList<ProjectLicense>();
    private boolean hasMatchLicenses = false;
    private List<String> downloaderMessages = new ArrayList<String>();
    private boolean approved;

    public ProjectLicenseInfo() {
    }

    public ProjectLicenseInfo(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ProjectLicenseInfo(String groupId, String artifactId, String version, boolean hasMatchLicenses) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.hasMatchLicenses = hasMatchLicenses;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<ProjectLicense> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<ProjectLicense> licenses) {
        this.licenses = licenses;
    }

    public void addLicense(ProjectLicense license) {
        this.licenses.add(license);
    }

    public List<ProjectLicense> getMatchLicenses() {
        return this.matchLicenses;
    }

    public void setMatchLicenses(List<ProjectLicense> matchLicenses) {
        this.matchLicenses = matchLicenses;
    }

    public void addMatchLicense(ProjectLicense license) {
        this.matchLicenses.add(license);
    }

    public boolean hasMatchLicenses() {
        return this.hasMatchLicenses;
    }

    public void setHasMatchLicenses(boolean hasMatchLicenses) {
        this.hasMatchLicenses = hasMatchLicenses;
    }

    public String getId() {
        return this.groupId + ":" + this.artifactId;
    }

    public List<String> getDownloaderMessages() {
        return this.downloaderMessages;
    }

    public void addDownloaderMessage(String message) {
        this.downloaderMessages.add(message);
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object compareTo) {
        ProjectLicenseInfo compare;
        if (compareTo instanceof ProjectLicenseInfo && this.groupId.equals((compare = (ProjectLicenseInfo)compareTo).getGroupId()) && this.artifactId.equals(compare.getArtifactId())) {
            return true;
        }
        return compareTo instanceof Artifact && this.groupId.equals((compare = (Artifact)compareTo).getGroupId()) && this.artifactId.equals(compare.getArtifactId());
    }

    public boolean deepEquals(ProjectLicenseInfo other) {
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.version, other.version) && Objects.equals(this.licenses, other.licenses) && Objects.equals(this.matchLicenses, other.matchLicenses) && Objects.equals(this.downloaderMessages, other.downloaderMessages);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public List<ProjectLicense> cloneLicenses() {
        try {
            ArrayList<ProjectLicense> result = new ArrayList<ProjectLicense>(this.licenses != null ? this.licenses.size() : 0);
            if (this.licenses != null) {
                for (ProjectLicense license : this.licenses) {
                    result.add(license.clone());
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public boolean isApproved() {
        return this.approved;
    }
}

