/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.AggregatorAddThirdPartyMojo;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="add-third-party", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class AddThirdPartyMojo
extends AbstractAddThirdPartyMojo
implements MavenProjectDependenciesConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(AddThirdPartyMojo.class);
    @Parameter(property="license.skipAddThirdParty", defaultValue="false")
    private boolean skipAddThirdParty;
    private boolean doGenerateMissing;
    private boolean isAggregatorBuild = false;
    private List<MavenProject> reactorProjectDependencies;
    private ResolvedProjectDependencies dependencyArtifacts;
    private ArtifactFilters artifactFilters;

    @Override
    public boolean isSkip() {
        return this.skipAddThirdParty;
    }

    @Override
    protected boolean checkPackaging() {
        if (this.acceptPomPackaging) {
            return true;
        }
        return this.rejectPackaging("pom");
    }

    @Override
    protected boolean shouldSkip() {
        return !this.doGenerate && !this.doGenerateBundle && !this.doGenerateMissing;
    }

    @Override
    protected void doAction() throws Exception {
        this.consolidate();
        this.checkUnsafeDependencies();
        boolean safeLicense = this.checkForbiddenLicenses();
        this.checkBlacklist(safeLicense);
        this.writeThirdPartyFile();
        if (this.doGenerateMissing) {
            this.writeMissingFile();
        }
        boolean unsafe = CollectionUtils.isNotEmpty((Collection)this.unsafeDependencies);
        this.checkMissing(unsafe);
        if (!unsafe && this.useMissingFile && MapUtils.isEmpty((Map)this.unsafeMappings) && this.missingFile.exists()) {
            LOG.info("There is no dependency to put in missing file, delete it at {}", (Object)this.missingFile);
            FileUtil.deleteFile(this.missingFile);
        }
        if (!unsafe && this.deployMissingFile && MapUtils.isNotEmpty((Map)this.unsafeMappings)) {
            LOG.info("Will attach third party file from {}", (Object)this.missingFile);
            this.getHelper().attachThirdPartyDescriptor(this.missingFile);
        }
        this.addResourceDir(this.outputDirectory, "**/*.txt");
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() throws DependenciesToolException {
        return this.getHelper().loadDependencies(this, this.resolveDependencyArtifacts());
    }

    protected ResolvedProjectDependencies resolveDependencyArtifacts() throws DependenciesToolException {
        if (this.dependencyArtifacts != null) {
            return this.dependencyArtifacts;
        }
        this.dependencyArtifacts = this.isAggregatorBuild ? new ResolvedProjectDependencies(this.project.getArtifacts(), MojoHelper.getDependencyArtifacts(this.project)) : new ResolvedProjectDependencies(this.project.getArtifacts(), MojoHelper.getDependencyArtifacts(this.project));
        return this.dependencyArtifacts;
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException, MojoExecutionException, DependenciesToolException {
        SortedProperties unsafeMappings = this.getHelper().createUnsafeMapping(this.licenseMap, this.missingFile, this.missingFileUrl, this.useRepositoryMissingFiles, this.unsafeDependencies, this.projectDependencies, this.resolveDependencyArtifacts().getAllDependencies());
        if (this.isVerbose()) {
            LOG.info("found {} unsafe mappings", (Object)unsafeMappings.size());
        }
        this.doGenerateMissing = this.computeDoGenerateMissingFile(unsafeMappings, this.unsafeDependencies);
        if (this.doGenerateMissing && this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Will use ");
            sb.append(unsafeMappings.size());
            sb.append(" dependencies from missingFile:");
            for (Map.Entry<Object, Object> entry : unsafeMappings.entrySet()) {
                String id = (String)entry.getKey();
                String license = (String)entry.getValue();
                sb.append("\n - ").append(id).append(" - ").append(license);
            }
            LOG.info("{}", (Object)sb);
        } else if (this.useMissingFile && !unsafeMappings.isEmpty()) {
            LOG.info("Missing file {} is up-to-date.", (Object)this.missingFile);
        }
        return unsafeMappings;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public ArtifactFilters getArtifactFilters() {
        if (this.artifactFilters == null) {
            this.artifactFilters = ArtifactFilters.of(this.includedGroups, this.excludedGroups, this.includedArtifacts, this.excludedArtifacts, this.includedScopes, this.excludedScopes, this.includedTypes, this.excludedTypes, this.includeOptional, this.artifactFiltersUrl, this.getEncoding());
        }
        return this.artifactFilters;
    }

    private boolean computeDoGenerateMissingFile(SortedProperties unsafeMappings, SortedSet<MavenProject> unsafeDependencies) throws IOException {
        if (!this.useMissingFile) {
            return false;
        }
        if (this.force) {
            return !CollectionUtils.isEmpty(unsafeMappings.keySet());
        }
        if (!CollectionUtils.isEmpty(unsafeDependencies)) {
            return true;
        }
        if (!this.missingFile.exists()) {
            return true;
        }
        SortedProperties oldUnsafeMappings = new SortedProperties(this.getEncoding());
        oldUnsafeMappings.load(this.missingFile);
        return !unsafeMappings.equals(oldUnsafeMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMissingFile() throws IOException {
        FileUtil.createDirectoryIfNecessary(this.missingFile.getParentFile());
        LOG.info("Regenerate missing license file {}", (Object)this.missingFile);
        try (FileOutputStream writer = new FileOutputStream(this.missingFile);){
            StringBuilder sb = new StringBuilder(" Generated by " + this.getClass().getName());
            ArrayList licenses = new ArrayList(this.licenseMap.keySet());
            licenses.remove("Unknown license");
            if (!licenses.isEmpty()) {
                sb.append("\n-------------------------------------------------------------------------------");
                sb.append("\n Already used licenses in project :");
                for (String license : licenses) {
                    sb.append("\n - ").append(license);
                }
            }
            sb.append("\n-------------------------------------------------------------------------------");
            sb.append("\n Please fill the missing licenses for dependencies :\n\n");
            this.unsafeMappings.store(writer, sb.toString());
        }
    }

    void initFromMojo(AggregatorAddThirdPartyMojo mojo, MavenProject mavenProject, List<MavenProject> reactorProjects) throws Exception {
        this.project = mavenProject;
        this.deployMissingFile = mojo.deployMissingFile;
        this.useRepositoryMissingFiles = mojo.useRepositoryMissingFiles;
        this.acceptPomPackaging = mojo.acceptPomPackaging;
        this.includeOptional = mojo.includeOptional;
        this.excludedScopes = mojo.excludedScopes;
        this.includedScopes = mojo.includedScopes;
        this.excludedGroups = mojo.excludedGroups;
        this.includedGroups = mojo.includedGroups;
        this.excludedArtifacts = mojo.excludedArtifacts;
        this.includedArtifacts = mojo.includedArtifacts;
        this.includeTransitiveDependencies = mojo.includeTransitiveDependencies;
        this.excludeTransitiveDependencies = mojo.excludeTransitiveDependencies;
        this.thirdPartyFilename = mojo.thirdPartyFilename;
        this.useMissingFile = mojo.useMissingFile;
        String absolutePath = mojo.getProject().getBasedir().getAbsolutePath();
        this.missingFile = new File(this.project.getBasedir(), mojo.missingFile.getAbsolutePath().substring(absolutePath.length()));
        this.resolvedOverrideUrl = mojo.resolvedOverrideUrl;
        this.missingLicensesFileArtifact = mojo.missingLicensesFileArtifact;
        this.dependencies = new HashSet(mavenProject.getDependencyArtifacts());
        this.licenseMerges = mojo.licenseMerges;
        this.licenseMergesFile = mojo.licenseMergesFile;
        this.includedLicenses = mojo.includedLicenses;
        this.excludedLicenses = mojo.excludedLicenses;
        this.bundleThirdPartyPath = mojo.bundleThirdPartyPath;
        this.generateBundle = mojo.generateBundle;
        this.force = mojo.force;
        this.failIfWarning = mojo.failIfWarning;
        this.failOnMissing = mojo.failOnMissing;
        this.failOnBlacklist = mojo.failOnBlacklist;
        this.sortArtifactByName = mojo.sortArtifactByName;
        this.fileTemplate = mojo.fileTemplate;
        this.session = mojo.session;
        this.verbose = mojo.verbose;
        this.encoding = mojo.encoding;
        this.setLog(mojo.getLog());
        this.isAggregatorBuild = true;
        this.reactorProjectDependencies = reactorProjects;
        this.init();
        this.consolidate();
    }
}

