/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.native2ascii.PropertyEscaper;

public final class Native2Ascii {
    private final Log log;
    private final CharSequenceTranslator escaper;

    public Native2Ascii(Log log) {
        this.log = log;
        this.escaper = new PropertyEscaper();
    }

    public String nativeToAscii(String string) {
        if (string == null) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Converting string: '" + string + "'"));
        }
        return this.escaper.translate((CharSequence)string);
    }

    public void nativeToAscii(File src, File dst, String encoding) throws IOException {
        this.log.debug((CharSequence)("Processing '" + src + "' to '" + dst + "'"));
        if (!dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), encoding));
             BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), StandardCharsets.ISO_8859_1));){
            int len;
            char[] buffer = new char[4096];
            while ((len = input.read(buffer)) != -1) {
                output.write(this.nativeToAscii(CharBuffer.wrap(buffer, 0, len).toString()));
            }
        }
    }
}

