/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.properties.AbstractPropertiesMojo;
import org.codehaus.mojo.properties.managers.PropertiesManager;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractWritePropertiesMojo
extends AbstractPropertiesMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true, property="properties.outputFile")
    private File outputFile;

    protected AbstractWritePropertiesMojo(List<PropertiesManager> propertiesManagers) {
        super(propertiesManagers);
    }

    protected void writeProperties(Properties properties) throws MojoExecutionException {
        try {
            PropertiesManager manager = this.getPropertiesManager(FileUtils.extension((String)this.outputFile.getName()));
            manager.save(properties, Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]), "Properties");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Could not create FileOutputStream: " + this.outputFile));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error writing properties: " + this.outputFile));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void validateOutputFile() throws MojoExecutionException {
        if (this.outputFile == null) {
            throw new MojoExecutionException("outputFile parameter is missing");
        }
        if (this.outputFile.isDirectory()) {
            throw new MojoExecutionException("outputFile must be a file and not a directory");
        }
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
    }

    public MavenProject getProject() {
        return this.project;
    }
}

