/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.Properties;
import org.codehaus.mojo.properties.CircularDefinitionPreventer;
import org.codehaus.mojo.properties.DefaultValuesAwareExpansionBufferImpl;
import org.codehaus.mojo.properties.ExpansionBuffer;
import org.codehaus.mojo.properties.ExpansionBufferImpl;
import org.codehaus.mojo.properties.KeyAndDefaultValue;

class PropertyResolver {
    PropertyResolver() {
    }

    public String getPropertyValue(String key, Properties properties, Properties environment) {
        return this.getPropertyValue(key, properties, environment, false);
    }

    public String getPropertyValue(String key, Properties properties, Properties environment, boolean useDefaultValues) {
        String value = properties.getProperty(key);
        ExpansionBuffer buffer = useDefaultValues ? new DefaultValuesAwareExpansionBufferImpl(value) : new ExpansionBufferImpl(value);
        CircularDefinitionPreventer circularDefinitionPreventer = new CircularDefinitionPreventer().visited(key, value);
        while (buffer.hasMoreLegalPlaceholders()) {
            KeyAndDefaultValue kv = buffer.extractPropertyKeyAndDefaultValue();
            String newKey = kv.getKey();
            String newValue = this.fromPropertiesThenSystemThenEnvironment(newKey, kv.getDefaultValue(), properties, environment);
            circularDefinitionPreventer.visited(newKey, newValue);
            buffer.add(newKey, newValue);
        }
        return buffer.toString();
    }

    private String fromPropertiesThenSystemThenEnvironment(String key, String defaultValue, Properties properties, Properties environment) {
        String value = properties.getProperty(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        if (value == null && key.startsWith("env.") && environment != null) {
            value = environment.getProperty(key.substring(4));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

