/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="display-dependency-updates", threadSafe=true)
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 72;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    private boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyManagementIncludes", defaultValue="*")
    private List<String> dependencyManagementIncludes;
    @Parameter(property="dependencyManagementExcludes")
    private List<String> dependencyManagementExcludes;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies;
    @Parameter(property="dependencyIncludes", defaultValue="*")
    private List<String> dependencyIncludes;
    @Parameter(property="dependencyExcludes")
    private List<String> dependencyExcludes;
    @Parameter(property="processPluginDependencies", defaultValue="true")
    private boolean processPluginDependencies;
    @Parameter(property="processPluginDependenciesInPluginManagement", defaultValue="true")
    private boolean processPluginDependenciesInPluginManagement;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates = true;
    @Deprecated
    @Parameter(property="allowAnyUpdates", defaultValue="true")
    private boolean allowAnyUpdates = true;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="pluginDependencyIncludes", defaultValue="*")
    private List<String> pluginDependencyIncludes;
    @Parameter(property="pluginDependencyExcludes")
    private List<String> pluginDependencyExcludes;
    @Parameter(property="pluginManagementDependencyIncludes", defaultValue="*")
    private List<String> pluginManagementDependencyIncludes;
    @Parameter(property="pluginManagementDependencyExcludes")
    private List<String> pluginManagementDependencyExcludes;

    @Inject
    public DisplayDependencyUpdatesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    protected static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        if (!managedDependency.getGroupId().equals(dependency.getGroupId())) {
            return false;
        }
        if (!managedDependency.getArtifactId().equals(dependency.getArtifactId())) {
            return false;
        }
        if (managedDependency.getScope() == null || Objects.equals(managedDependency.getScope(), dependency.getScope())) {
            return false;
        }
        if (managedDependency.getClassifier() == null || Objects.equals(managedDependency.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        return dependency.getVersion() == null || managedDependency.getVersion() == null || Objects.equals(managedDependency.getVersion(), dependency.getVersion());
    }

    public boolean isProcessingDependencyManagement() {
        return this.processDependencyManagement;
    }

    public boolean isProcessingDependencies() {
        return this.processDependencies;
    }

    public boolean isProcessingPluginDependencies() {
        return this.processPluginDependencies;
    }

    public boolean isProcessPluginDependenciesInDependencyManagement() {
        return this.processPluginDependenciesInPluginManagement;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        this.validateInput();
        Set dependencyManagement = Collections.emptySet();
        try {
            if (this.isProcessingDependencyManagement()) {
                dependencyManagement = DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)this.getProject(), (boolean)this.processDependencyManagementTransitive, (Log)this.getLog()), this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependecy Management", (Log)this.getLog());
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement, false), "Dependency Management");
            }
            if (this.isProcessingDependencies()) {
                Set finalDependencyManagement = dependencyManagement;
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)this.getProject().getDependencies().parallelStream().filter(dep -> finalDependencyManagement.parallelStream().noneMatch(depMan -> DisplayDependencyUpdatesMojo.dependenciesMatch(dep, depMan))).collect(() -> new TreeSet(DependencyComparator.INSTANCE), Set::add, Set::addAll), this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)this.getLog()), false), "Dependencies");
            }
            if (this.isProcessPluginDependenciesInDependencyManagement()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)this.getProject()), this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)this.getLog()), false), "pluginManagement of plugins");
            }
            if (this.isProcessingPluginDependencies()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)this.getProject()), this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)this.getLog()), false), "Plugin Dependencies");
            }
        }
        catch (VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected void validateInput() throws MojoExecutionException {
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyIncludes, 6, "dependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyExcludes, 6, "dependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyIncludes, 3, "pluginDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyExcludes, 3, "pluginDependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyIncludes, 3, "pluginManagementDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyExcludes, 3, "pluginManagementDependencyExcludes");
    }

    static void validateGAVList(List<String> gavList, int numSections, String argumentName) throws MojoExecutionException {
        if (gavList != null && gavList.stream().anyMatch(gav -> org.apache.commons.lang3.StringUtils.countMatches((CharSequence)gav, (CharSequence)":") >= numSections)) {
            throw new MojoExecutionException(argumentName + " should not contain more than 6 segments");
        }
    }

    private Optional<Segment> calculateUpdateScope() {
        return this.allowAnyUpdates ? Optional.empty() : Optional.of(SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog()).map(s -> Segment.of((int)(s.value() + 1))).orElse(Segment.MAJOR));
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> updates, String section) {
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            ArtifactVersion latest;
            String current;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.isCurrentVersionDefined()) {
                current = versions.getCurrentVersion().toString();
                latest = versions.getNewestUpdate(this.calculateUpdateScope(), this.allowSnapshots);
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), this.allowSnapshots);
                current = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : versions.getNewestUpdate(newestVersion, this.calculateUpdateScope(), this.allowSnapshots);
                if (latest != null && ArtifactVersions.isVersionInRange((ArtifactVersion)latest, (VersionRange)versions.getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            String right = " " + (latest == null ? current : current + " -> " + latest);
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72 + this.getOutputLineWidthOffset()) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)(72 + this.getOutputLineWidthOffset())));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 + this.getOutputLineWidthOffset() - right.length()), (String)".") + right);
        }
        if (this.isVerbose()) {
            if (usingCurrent.isEmpty()) {
                if (!withUpdates.isEmpty()) {
                    this.logLine(false, "No dependencies in " + section + " are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following dependencies in " + section + " are using the newest version:");
                for (String s : usingCurrent) {
                    this.logLine(false, s);
                }
                this.logLine(false, "");
            }
        }
        if (withUpdates.isEmpty()) {
            if (!usingCurrent.isEmpty()) {
                this.logLine(false, "No dependencies in " + section + " have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following dependencies in " + section + " have newer versions:");
            for (String withUpdate : withUpdates) {
                this.logLine(false, withUpdate);
            }
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) {
    }
}

