/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.mojo.versions.utils.PropertyComparator;
import org.codehaus.mojo.versions.xml.PropertyUpdatesXmlReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractPropertyUpdatesReportMojo
extends AbstractVersionsReport<PropertyUpdatesModel> {
    private static final PropertyComparator PROPERTIES_COMPARATOR = PropertyComparator.INSTANCE;
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="includeParent", defaultValue="true")
    private boolean includeParent = true;
    @Parameter(property="propertyUpdatesReportFormats", defaultValue="html")
    protected String[] formats = new String[]{"html"};

    public AbstractPropertyUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, aetherRepositorySystem, wagonMap, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildProperties();
    }

    protected boolean haveBuildProperties() {
        return this.getProject().getProperties() != null && !this.getProject().getProperties().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        try {
            TreeMap<Property, PropertyVersions> updateSet = new TreeMap<Property, PropertyVersions>((Comparator<Property>)PROPERTIES_COMPARATOR);
            this.populateUpdateSet(updateSet);
            this.renderReport(locale, sink, this.getPropertyUpdatesModel(updateSet));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected abstract void populateUpdateSet(Map<Property, PropertyVersions> var1) throws MojoExecutionException, MavenReportException;

    private void renderReport(Locale locale, Sink sink, PropertyUpdatesModel propertyUpdatesModel) throws MavenReportException {
        for (String format : this.formats) {
            if ("html".equals(format)) {
                this.rendererFactory.createReportRenderer(this.getOutputName(), sink, locale, propertyUpdatesModel).render();
                continue;
            }
            if (!"xml".equals(format)) continue;
            Path outputDir = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            if (!Files.exists(outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MavenReportException("Could not create the output directory");
                }
            }
            Path outputFile = outputDir.resolve(this.getOutputName() + ".xml");
            new PropertyUpdatesXmlReportRenderer(propertyUpdatesModel, outputFile).render();
        }
    }

    private PropertyUpdatesModel getPropertyUpdatesModel(Map<Property, PropertyVersions> updateSet) {
        return new PropertyUpdatesModel(PROPERTIES_COMPARATOR, updateSet);
    }

    protected VersionsHelper.VersionPropertiesMapRequest getRequest(MavenProject project) {
        return VersionsHelper.VersionPropertiesMapRequest.builder().withMavenProject(project).withPropertyDefinitions(this.properties).withIncludeProperties(this.includeProperties).withExcludeProperties(this.excludeProperties).withIncludeParent(this.includeParent).withAutoLinkItems(this.autoLinkItems).build();
    }

    public String getOutputName() {
        return "property-updates-report";
    }
}

