/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public abstract class AbstractUpdatesModel<V extends ArtifactVersions> {
    private final Map<Dependency, V> artifactUpdates;
    private final Map<Dependency, V> artifactManagementUpdates;
    private final Map<Dependency, V> allUpdates;

    public <K> AbstractUpdatesModel(Map<K, V> artifactUpdates, Map<K, V> artifactManagementUpdates, Function<K, Dependency> supplier) {
        this.artifactUpdates = artifactUpdates.entrySet().stream().collect(() -> new TreeMap(DependencyComparator.INSTANCE), (map, entry) -> {
            ArtifactVersions cfr_ignored_0 = (ArtifactVersions)map.put(supplier.apply(entry.getKey()), entry.getValue());
        }, Map::putAll);
        this.artifactManagementUpdates = artifactManagementUpdates.entrySet().stream().collect(() -> new TreeMap(DependencyComparator.INSTANCE), (map, entry) -> {
            ArtifactVersions cfr_ignored_0 = (ArtifactVersions)map.put(supplier.apply(entry.getKey()), entry.getValue());
        }, Map::putAll);
        this.allUpdates = new TreeMap<Dependency, V>((Comparator<Dependency>)DependencyComparator.INSTANCE);
        this.allUpdates.putAll(this.artifactManagementUpdates);
        this.allUpdates.putAll(this.artifactUpdates);
    }

    public Map<Dependency, V> getArtifactUpdates() {
        return this.artifactUpdates;
    }

    public Map<Dependency, V> getArtifactManagementUpdates() {
        return this.artifactManagementUpdates;
    }

    public Map<Dependency, V> getAllUpdates() {
        return this.allUpdates;
    }
}

