/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.ReportRenderer;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.PropertyAssociation;
import org.codehaus.mojo.versions.reporting.model.PropertyInfo;
import org.codehaus.mojo.versions.reporting.model.PropertyReportSummary;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.xpp3.PropertyUpdatesReportXpp3Writer;
import org.codehaus.mojo.versions.xml.CommonXmlReportRendererUtils;

public class PropertyUpdatesXmlReportRenderer
implements ReportRenderer {
    private final PropertyUpdatesModel model;
    private final Path outputFile;
    private final ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getNewestUpdate);

    public PropertyUpdatesXmlReportRenderer(PropertyUpdatesModel model, Path outputFile) {
        this.model = model;
        this.outputFile = outputFile;
    }

    public void render() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            new PropertyUpdatesReportXpp3Writer().write((Writer)writer, new PropertyUpdatesReport(){
                {
                    this.setSummary(new PropertyReportSummary(){
                        {
                            Object overviewStats = OverviewStats.fromUpdates(PropertyUpdatesXmlReportRenderer.this.model.getAllUpdates().values(), PropertyUpdatesXmlReportRenderer.this.newestUpdateCache);
                            this.setUsingLastVersion(String.valueOf(((OverviewStats)overviewStats).getUpToDate()));
                            this.setNextVersionAvailable(String.valueOf(((OverviewStats)overviewStats).getAny()));
                            this.setNextIncrementalAvailable(String.valueOf(((OverviewStats)overviewStats).getIncremental()));
                            this.setNextMinorAvailable(String.valueOf(((OverviewStats)overviewStats).getMinor()));
                            this.setNextMajorAvailable(String.valueOf(((OverviewStats)overviewStats).getMajor()));
                        }
                    });
                    this.setProperties(PropertyUpdatesXmlReportRenderer.createPropertyInfo(PropertyUpdatesXmlReportRenderer.this.model.getAllUpdates()));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<PropertyInfo> createPropertyInfo(Map<Property, PropertyVersions> versions) {
        return versions.entrySet().stream().map(e -> new PropertyInfo((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
                this.setPropertyName(((Property)this.val$e.getKey()).getName());
                if (((PropertyVersions)this.val$e.getValue()).getAssociations() != null && ((PropertyVersions)this.val$e.getValue()).getAssociations().length != 0) {
                    this.setPropertyAssociations(Arrays.stream(((PropertyVersions)this.val$e.getValue()).getAssociations()).map(a -> {
                        PropertyAssociation pa = new PropertyAssociation();
                        pa.setGroupId(a.getGroupId());
                        pa.setArtifactId(a.getArtifactId());
                        return pa;
                    }).collect(Collectors.toList()));
                }
                this.setCurrentVersion(((Property)this.val$e.getKey()).getVersion());
                Optional.ofNullable(((PropertyVersions)this.val$e.getValue()).getNewestUpdate(Optional.empty())).map(Object::toString).ifPresent(arg_0 -> (this).setLastVersion(arg_0));
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.INCREMENTAL, arg_0 -> (this).setIncrementals(arg_0));
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MINOR, arg_0 -> (this).setMinors(arg_0));
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MAJOR, arg_0 -> (this).setMajors(arg_0));
                this.setStatus(CommonXmlReportRendererUtils.statusFor(this.getLastVersion(), this.getIncrementals(), this.getMinors()));
            }
        }).collect(Collectors.toList());
    }
}

