/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.VersionInformation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="use-dynamic-version-from-scm", defaultPhase=LifecyclePhase.INITIALIZE)
public class DynamicVersioningSCMPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="propertyName", defaultValue="revision")
    protected String propertyName;
    @Parameter(property="appendSnapshot", defaultValue="true")
    protected boolean appendSnapshot;
    @Parameter(property="useVersion")
    protected String useVersion;
    @Parameter(property="defaultVersion", defaultValue="0.0.1")
    protected String defaultVersion;
    protected static final Pattern TAG_VERSION_PATTERN = Pattern.compile("refs/tags/(?:v)?((\\d+\\.\\d+\\.\\d+)(.*))");

    public void execute() throws MojoExecutionException {
        Logger.getLogger("org.eclipse.jgit").setLevel(Level.INFO);
        Optional<String> mayBeVersion = Optional.ofNullable(this.useVersion);
        VersionInformation vi = mayBeVersion.isPresent() ? new VersionInformation(mayBeVersion.get()) : this.getVersionFromSCM();
        this.project.getProperties().setProperty(this.propertyName, vi.toString());
        this.getLog().info((CharSequence)("Property '" + this.propertyName + "' set to: " + this.project.getProperties().getProperty(this.propertyName)));
    }

    protected VersionInformation getVersionFromSCM() throws MojoExecutionException {
        VersionInformation versionInformation;
        block9: {
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(".git"))).readEnvironment()).findGitDir()).build();
            try {
                if (repository.getDirectory() == null) {
                    throw new MojoExecutionException("Directory is not an SCM repository.");
                }
                RevCommit latestCommit = this.getLatestCommit(repository);
                versionInformation = this.getVersionFromCommit(repository, latestCommit);
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading Git information.", (Exception)e);
                }
            }
            repository.close();
        }
        return versionInformation;
    }

    protected RevCommit getLatestCommit(Repository repository) throws MojoExecutionException {
        RevCommit revCommit;
        RevWalk revWalk = new RevWalk(repository);
        try {
            ObjectId head = repository.resolve("HEAD");
            if (head == null) {
                throw new MojoExecutionException("SCM repo has no head/commits.");
            }
            revCommit = revWalk.parseCommit((AnyObjectId)head);
        }
        catch (Throwable throwable) {
            try {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("SCM repo most likely has no commits.", (Exception)e);
            }
        }
        revWalk.close();
        return revCommit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VersionInformation getVersionFromCommit(Repository repository, RevCommit latestCommit) throws MojoExecutionException {
        try (Git git = Git.wrap((Repository)repository);){
            List<String> versionTags = this.getVersionedTagsForCommit(git, latestCommit);
            Optional<VersionInformation> ovi = this.findHighestVersion(versionTags);
            if (ovi.isPresent()) {
                VersionInformation versionInformation = ovi.get();
                return versionInformation;
            }
            Iterable commits = git.log().call();
            int count = 0;
            for (RevCommit commit : commits) {
                ++count;
                versionTags = this.getVersionedTagsForCommit(git, commit);
                ovi = this.findHighestVersion(versionTags);
                if (!ovi.isPresent()) continue;
                VersionInformation vi = ovi.get();
                vi.setPatch(vi.getPatch() + 1);
                vi.setBuildNumber(count);
                VersionInformation versionInformation = this.addSnapshotQualifier(vi);
                return versionInformation;
            }
            VersionInformation versionInformation = this.addSnapshotQualifier(new VersionInformation(this.defaultVersion + "-" + count));
            return versionInformation;
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("Error reading Git information.", (Exception)((Object)e));
        }
    }

    protected Optional<VersionInformation> findHighestVersion(List<String> versionTags) {
        Optional<String> highestVersionString = versionTags.stream().max(new VersionComparator());
        return highestVersionString.map(VersionInformation::new);
    }

    protected List<String> getVersionedTagsForCommit(Git git, RevCommit commit) throws GitAPIException {
        return git.tagList().call().stream().filter(tag -> tag.getObjectId().equals((AnyObjectId)commit.getId())).map(Ref::getName).filter(tagName -> {
            Matcher matcher = TAG_VERSION_PATTERN.matcher((CharSequence)tagName);
            return matcher.matches() && matcher.groupCount() > 0;
        }).map(tagName -> {
            Matcher matcher = TAG_VERSION_PATTERN.matcher((CharSequence)tagName);
            matcher.matches();
            return matcher.group(1);
        }).collect(Collectors.toList());
    }

    protected VersionInformation addSnapshotQualifier(VersionInformation vi) {
        if (this.appendSnapshot) {
            vi.setQualifier("SNAPSHOT");
        }
        return vi;
    }

    protected class VersionComparator
    implements Comparator<String> {
        protected VersionComparator() {
        }

        @Override
        public int compare(String version1, String version2) {
            return new ComparableVersion(version1).compareTo(new ComparableVersion(version2));
        }
    }
}

