/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;

@Mojo(name="lock-snapshots", threadSafe=true)
public class LockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final Pattern TIMESTAMPED_SNAPSHOT_REGEX = Pattern.compile("-SNAPSHOT");

    @Inject
    public LockSnapshotsMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.lockSnapshots(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.lockSnapshots(pom, this.getProject().getDependencies());
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.lockParentSnapshot(pom, this.getProject().getParent());
            }
        }
        catch (IOException | VersionResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void lockSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, VersionResolutionException {
        for (Dependency dep : dependencies) {
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length()) continue;
            Optional<String> lockedVersion = this.resolveSnapshotVersion(dep);
            if (lockedVersion.isPresent()) {
                if (!PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)version, (String)lockedVersion.get(), (Model)this.getProject().getModel())) continue;
                this.getLog().info((CharSequence)("Locked " + this.toString(dep) + " to version " + lockedVersion.get()));
                continue;
            }
            this.getLog().info((CharSequence)("No timestamped version for " + this.toString(dep) + " found."));
        }
    }

    protected void lockParentSnapshot(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, VersionResolutionException {
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length()) {
            Optional<String> lockedParentVersion = this.resolveSnapshotVersion(parentArtifact);
            if (lockedParentVersion.isPresent()) {
                if (PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)lockedParentVersion.get())) {
                    this.getLog().info((CharSequence)("Locked parent " + parentArtifact + " to version " + lockedParentVersion.get()));
                }
            } else {
                this.getLog().info((CharSequence)("No timestamped version for " + parentArtifact + " found."));
            }
        }
    }

    private Optional<String> resolveSnapshotVersion(Artifact artifact) throws VersionResolutionException {
        this.getLog().debug((CharSequence)("Resolving snapshot version for artifact: " + artifact));
        VersionResult versionResult = this.repositorySystem.resolveVersion(this.session.getRepositorySession(), new VersionRequest(RepositoryUtils.toArtifact((Artifact)artifact), this.getProject().getRemoteProjectRepositories(), ((Object)((Object)this)).getClass().getSimpleName()));
        return Optional.ofNullable(versionResult.getVersion()).filter(v -> !String.valueOf(artifact.getVersion()).equals(v));
    }

    private Optional<String> resolveSnapshotVersion(Dependency dep) throws MojoExecutionException, VersionResolutionException {
        return this.resolveSnapshotVersion(this.getHelper().createDependencyArtifact(dep));
    }
}

