/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="use-latest-releases", threadSafe=true)
public class UseLatestReleasesMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;

    @Inject
    public UseLatestReleasesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getProcessDependencies() {
        return this.processDependencies;
    }

    @Override
    protected boolean getProcessDependencyManagement() {
        return this.processDependencyManagement;
    }

    @Override
    public boolean getProcessParent() {
        return this.processParent;
    }

    @Override
    protected final boolean getAllowMajorUpdates() {
        return this.allowMajorUpdates;
    }

    @Override
    protected final boolean getAllowMinorUpdates() {
        return this.allowMinorUpdates;
    }

    @Override
    protected final boolean getAllowIncrementalUpdates() {
        return this.allowIncrementalUpdates;
    }

    @Override
    protected final boolean getAllowSnapshots() {
        return false;
    }

    @Override
    protected final boolean getAllowDowngrade() {
        return this.allowDowngrade;
    }

    @Override
    protected boolean updateFilter(Dependency dep) {
        return this.getAllowDowngrade() || !ArtifactUtils.isSnapshot((String)dep.getVersion());
    }

    @Override
    protected boolean artifactVersionsFilter(ArtifactVersion ver) {
        return true;
    }

    @Override
    protected Optional<ArtifactVersion> versionProducer(Stream<ArtifactVersion> stream) {
        return stream.max(Comparator.naturalOrder());
    }
}

