package org.codehaus.mojo.versions.utils;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.plugin.logging.Log;

/**
 * A {@link org.apache.maven.plugin.logging.Log} that knows about multiple contexts and can report on those contexts
 * with separators between each context
 *
 * @author Stephen Connolly
 * @since 15-Sep-2010 15:51:06
 */
public interface ContextualLog extends Log {

    /**
     * Set the current context. This will be printed before any log messages.
     *
     * @param context the context (e.g. the artifact being processed)
     */
    void setContext(String context);

    /**
     * Clear the current context.
     */
    void clearContext();
}
