/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Optional;

public enum Segment implements Comparable<Segment>
{
    MAJOR,
    MINOR,
    INCREMENTAL,
    SUBINCREMENTAL;


    public int value() {
        return this.ordinal();
    }

    public static Segment of(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("Wrong segment index: " + index);
        }
        return Segment.values()[index];
    }

    public static Segment majorTo(Segment other) {
        return Optional.ofNullable(other).map(s -> Segment.of(s.value() - 1)).orElse(null);
    }

    public static Segment minorTo(Segment other) {
        return Optional.ofNullable(other).map(s -> Segment.of(s.value() + 1)).orElse(MAJOR);
    }

    public boolean isMajorTo(Segment other) {
        return this.value() < other.value();
    }

    public String toString() {
        return this.name();
    }
}

