/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Comparator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.codehaus.mojo.versions.utils.VersionStringComparator;

public enum PluginComparator implements Comparator<Object>
{
    INSTANCE;


    private static boolean isPluginOrReportPlugin(Object o) {
        return o instanceof Plugin || o instanceof ReportPlugin;
    }

    private static String getGroupId(Object o) {
        return o instanceof Plugin ? ((Plugin)o).getGroupId() : (o instanceof ReportPlugin ? ((ReportPlugin)o).getGroupId() : "");
    }

    private static String getArtifactId(Object o) {
        return o instanceof Plugin ? ((Plugin)o).getArtifactId() : (o instanceof ReportPlugin ? ((ReportPlugin)o).getArtifactId() : "");
    }

    private static String getVersion(Object o) {
        return o instanceof Plugin ? ((Plugin)o).getVersion() : (o instanceof ReportPlugin ? ((ReportPlugin)o).getVersion() : "");
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (!PluginComparator.isPluginOrReportPlugin(o1) || !PluginComparator.isPluginOrReportPlugin(o2)) {
            throw new IllegalArgumentException("This comparator can only be used to compare Plugin and ReportPlugin instances");
        }
        if (o1 == o2) {
            return 0;
        }
        return Comparator.nullsLast(Comparator.comparing(PluginComparator::getGroupId).thenComparing(PluginComparator::getArtifactId).thenComparing(PluginComparator::getVersion, VersionStringComparator.STRICT)).compare(o1, o2);
    }
}

