// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.5.1,
// any modifications will be overwritten.
// ==============================================================

package org.codehaus.mojo.versions.reporting.model.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.XMLConstants;
import javax.xml.stream.*;
import org.codehaus.mojo.versions.reporting.model.PluginInfo;
import org.codehaus.mojo.versions.reporting.model.PluginReportSummary;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesReport;

/**
 * Class PluginUpdatesReportStaxReader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class PluginUpdatesReportStaxReader
{

      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method determineVersion.
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return String
     */
    public String determineVersion( Reader reader )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );
        while ( xmlStreamReader.hasNext() )
        {
            int eventType = xmlStreamReader.next();
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                return getVersionFromRootNamespace( xmlStreamReader );
            }
        }
        throw new XMLStreamException( "Version not found in document", xmlStreamReader.getLocation() );
    } //-- String determineVersion( Reader )

    /**
     * Method getVersionFromRootNamespace.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return String
     */
    private String getVersionFromRootNamespace( XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        String uri = xmlStreamReader.getNamespaceURI( "" );
        if ( uri == null )
        {
            throw new XMLStreamException( "No namespace specified, but versionDefinition requires it", xmlStreamReader.getLocation() );
        }
        String uriPrefix = "https://www.mojohaus.org/VERSIONS/PLUGIN-UPDATES-REPORT/";
        String uriSuffix = "";
        if ( !uri.startsWith( uriPrefix ) || !uri.endsWith( uriSuffix ) )
        {
            throw new XMLStreamException( "Namespace URI: '" + uri + "' does not match pattern 'https://www.mojohaus.org/VERSIONS/PLUGIN-UPDATES-REPORT/${version}'", xmlStreamReader.getLocation() );
        }
        return uri.substring( uriPrefix.length(), uri.length() - uriSuffix.length() );
    } //-- String getVersionFromRootNamespace( XMLStreamReader )

    /**
     * Method read.
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( Reader reader, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );

        return read( xmlStreamReader, strict );
    } //-- PluginUpdatesReport read( Reader, boolean )

    /**
     * Method read.
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( Reader reader )
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- PluginUpdatesReport read( Reader )

    /**
     * Method read.
     * 
     * @param stream a stream object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( InputStream stream, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( stream );

        return read( xmlStreamReader, strict );
    } //-- PluginUpdatesReport read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param stream a stream object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( InputStream stream )
        throws IOException, XMLStreamException
    {
        return read( stream, true );
    } //-- PluginUpdatesReport read( InputStream )

    /**
     * Method read.
     * 
     * @param filePath a filePath object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( String filePath, boolean strict )
        throws IOException, XMLStreamException
    {
        java.io.File file = new java.io.File( filePath );
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURI().toURL().toExternalForm(), new FileInputStream( file ) );

        return read( xmlStreamReader, strict );
    } //-- PluginUpdatesReport read( String, boolean )

    /**
     * Method read.
     * 
     * @param filePath a filePath object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    public PluginUpdatesReport read( String filePath )
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- PluginUpdatesReport read( String )

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XMLStreamReader xmlStreamReader, String tagName, String alias, java.util.Set parsed )
        throws XMLStreamException
    {
        if ( !( xmlStreamReader.getLocalName().equals( tagName ) || xmlStreamReader.getLocalName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XMLStreamException( "Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation() );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XMLStreamReader, String, String, java.util.Set )

    /**
     * Method checkUnknownElement.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if any.
     */
    private void checkUnknownElement( XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( strict )
        {
            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
        }
        int unrecognizedTagCount = 1;
        while( unrecognizedTagCount != 0 )
        {
            xmlStreamReader.next();
            if ( xmlStreamReader.getEventType() == XMLStreamConstants.START_ELEMENT )
            {
                unrecognizedTagCount++;
            }
            else if ( xmlStreamReader.getEventType() == XMLStreamConstants.END_ELEMENT )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XMLStreamReader, boolean )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XMLStreamReader )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XMLStreamReader )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XMLStreamReader )

    /**
     * Method getDefaultValue.
     * 
     * @param s a s object.
     * @param v a v object.
     * @return String
     */
    private String getDefaultValue( String s, String v )
    {
        if ( s == null )
        {
            s = v;
        }
        return s;
    } //-- String getDefaultValue( String, String )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param xmlStreamReader a xmlStreamReader object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @throws XMLStreamException XMLStreamException if any.
     * @return int
     */
    private int nextTag( XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        while ( true )
        {
            int eventType = xmlStreamReader.next();
            switch ( eventType )
            {
                case XMLStreamConstants.CHARACTERS:
                case XMLStreamConstants.CDATA:
                case XMLStreamConstants.SPACE:
                case XMLStreamConstants.PROCESSING_INSTRUCTION:
                case XMLStreamConstants.COMMENT:
                    break;
                case XMLStreamConstants.START_ELEMENT:
                case XMLStreamConstants.END_ELEMENT:
                    return eventType;
                default:
                    throw new XMLStreamException( "expected start or end tag", xmlStreamReader.getLocation() );
            }
        }
    } //-- int nextTag( XMLStreamReader )

    /**
     * Method parsePluginInfo.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginInfo
     */
    private PluginInfo parsePluginInfo( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        PluginInfo pluginInfo = new PluginInfo();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "groupId", null, parsed ) )
            {
                pluginInfo.setGroupId( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "artifactId", null, parsed ) )
            {
                pluginInfo.setArtifactId( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "scope", null, parsed ) )
            {
                pluginInfo.setScope( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "classifier", null, parsed ) )
            {
                pluginInfo.setClassifier( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "type", null, parsed ) )
            {
                pluginInfo.setType( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "currentVersion", null, parsed ) )
            {
                pluginInfo.setCurrentVersion( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "lastVersion", null, parsed ) )
            {
                pluginInfo.setLastVersion( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "any", null, parsed ) )
            {
                java.util.List any = new java.util.ArrayList/*<String>*/();
                pluginInfo.setAny( any );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "any".equals( xmlStreamReader.getLocalName() ) )
                    {
                        any.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "incrementals", null, parsed ) )
            {
                java.util.List incrementals = new java.util.ArrayList/*<String>*/();
                pluginInfo.setIncrementals( incrementals );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "incremental".equals( xmlStreamReader.getLocalName() ) )
                    {
                        incrementals.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "minors", null, parsed ) )
            {
                java.util.List minors = new java.util.ArrayList/*<String>*/();
                pluginInfo.setMinors( minors );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "minor".equals( xmlStreamReader.getLocalName() ) )
                    {
                        minors.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "majors", null, parsed ) )
            {
                java.util.List majors = new java.util.ArrayList/*<String>*/();
                pluginInfo.setMajors( majors );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "major".equals( xmlStreamReader.getLocalName() ) )
                    {
                        majors.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "status", null, parsed ) )
            {
                pluginInfo.setStatus( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return pluginInfo;
    } //-- PluginInfo parsePluginInfo( XMLStreamReader, boolean )

    /**
     * Method parsePluginReportSummary.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginReportSummary
     */
    private PluginReportSummary parsePluginReportSummary( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        PluginReportSummary pluginReportSummary = new PluginReportSummary();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "usingLastVersion", null, parsed ) )
            {
                pluginReportSummary.setUsingLastVersion( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "nextVersionAvailable", null, parsed ) )
            {
                pluginReportSummary.setNextVersionAvailable( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "nextIncrementalAvailable", null, parsed ) )
            {
                pluginReportSummary.setNextIncrementalAvailable( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "nextMinorAvailable", null, parsed ) )
            {
                pluginReportSummary.setNextMinorAvailable( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "nextMajorAvailable", null, parsed ) )
            {
                pluginReportSummary.setNextMajorAvailable( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "dependencyUpdates", null, parsed ) )
            {
                pluginReportSummary.setDependencyUpdates( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return pluginReportSummary;
    } //-- PluginReportSummary parsePluginReportSummary( XMLStreamReader, boolean )

    /**
     * Method parsePluginUpdatesReport.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    private PluginUpdatesReport parsePluginUpdatesReport( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        PluginUpdatesReport pluginUpdatesReport = new PluginUpdatesReport();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "summary", null, parsed ) )
            {
                pluginUpdatesReport.setSummary( parsePluginReportSummary( xmlStreamReader, strict ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "pluginManagements", null, parsed ) )
            {
                java.util.List pluginManagements = new java.util.ArrayList/*<PluginInfo>*/();
                pluginUpdatesReport.setPluginManagements( pluginManagements );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "pluginManagement".equals( xmlStreamReader.getLocalName() ) )
                    {
                        pluginUpdatesReport.addPluginManagement( parsePluginInfo( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "plugins", null, parsed ) )
            {
                java.util.List plugins = new java.util.ArrayList/*<PluginInfo>*/();
                pluginUpdatesReport.setPlugins( plugins );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "plugin".equals( xmlStreamReader.getLocalName() ) )
                    {
                        pluginUpdatesReport.addPlugin( parsePluginInfo( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return pluginUpdatesReport;
    } //-- PluginUpdatesReport parsePluginUpdatesReport( XMLStreamReader, boolean )

    /**
     * Method read.
     * 
     * @param xmlStreamReader a xmlStreamReader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if any.
     * @return PluginUpdatesReport
     */
    private PluginUpdatesReport read( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while ( eventType != XMLStreamConstants.END_DOCUMENT )
        {
            if ( eventType == XMLStreamConstants.START_DOCUMENT )
            {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( strict && ! "PluginUpdatesReport".equals( xmlStreamReader.getLocalName() ) )
                {
                    throw new XMLStreamException( "Expected root element 'PluginUpdatesReport' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null );
                }
                String modelVersion = getVersionFromRootNamespace( xmlStreamReader );
                // legacy hack for pomVersion == 3
                if ( "3".equals( modelVersion ) )
                {
                    modelVersion = "3.0.0";
                }
                if ( !"2.0.0".equals( modelVersion ) )
                {
                    throw new XMLStreamException( "Document model version of '" + modelVersion + "' doesn't match reader version of '2.0.0'", xmlStreamReader.getLocation() );
                }
                PluginUpdatesReport pluginUpdatesReport = parsePluginUpdatesReport( xmlStreamReader, strict );
                pluginUpdatesReport.setModelEncoding( encoding );
                resolveReferences( pluginUpdatesReport );
                return pluginUpdatesReport;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException( "Expected root element 'PluginUpdatesReport' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null );
    } //-- PluginUpdatesReport read( XMLStreamReader, boolean )

    /**
     * Method resolveReferences.
     * 
     * @param value a value object.
     */
    private void resolveReferences( PluginUpdatesReport value )
    {
        java.util.Map refs;
    } //-- void resolveReferences( PluginUpdatesReport )

}
