/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;

public abstract class AbstractWeblogicMojo
extends AbstractMojo {
    public static final String WEBLOGIC_HOME_KEY = "weblogic.home";
    private String weblogicHome;
    private Set artifacts;
    private List dependencies;
    private List pluginArtifacts;
    private String outputDirectory;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private String toolsJar;

    public String getWeblogicHome() {
        return this.weblogicHome;
    }

    public void setWeblogicHome(String weblogicHome) {
        this.weblogicHome = weblogicHome;
    }

    public Set getArtifacts() {
        return this.artifacts;
    }

    public final void setArtifacts(Set inArtifacts) {
        this.artifacts = inArtifacts;
    }

    public void execute() throws MojoExecutionException {
        this.setProperties();
        this.createTargetDirectory();
    }

    protected void setProperties() {
        if (System.getProperty(WEBLOGIC_HOME_KEY) == null || System.getProperty(WEBLOGIC_HOME_KEY).trim().length() == 0) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(" Setting weblogic.home = " + this.weblogicHome));
            }
            if (this.weblogicHome == null && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)" Is the property weblogicHome configured? Users should configure this property to help weblogic functions perform as expected.");
            } else if (this.weblogicHome != null) {
                File home = new File(this.weblogicHome);
                if (!home.exists()) {
                    this.getLog().warn((CharSequence)("weblogic.home folder '" + this.weblogicHome + "' does not appear to exist. This " + "may cause issues with some weblogic functions."));
                }
                System.setProperty(WEBLOGIC_HOME_KEY, this.weblogicHome);
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("weblogicHome property was set externally to '" + System.getProperty(WEBLOGIC_HOME_KEY) + "'."));
        }
    }

    protected void addToolsJar(ClassLoader classLoader) throws Exception {
        if (this.toolsJar == null || this.toolsJar.trim().length() == 0) {
            throw new MojoExecutionException("toolsJar is required for this mojo.");
        }
        File f = new File(this.toolsJar);
        if (!f.exists()) {
            throw new MojoExecutionException("toolsJar was supplied but not found. was java.home correct?");
        }
        try {
            URL u = f.toURI().toURL();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, u);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exceptions while setting up the classloader", e);
        }
    }

    protected BuildListener getDefaultLogger() {
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
        return antLogger;
    }

    protected void createTargetDirectory() {
        File file = new File(this.outputDirectory);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List dependencies) {
        this.dependencies = dependencies;
    }

    public List getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    protected File getWeblogicJar() {
        return new File(this.weblogicHome + "/server/lib/weblogic.jar");
    }

    protected File[] getWseeClientJars() {
        File dir = new File(this.weblogicHome + "/server/lib/wseeclient");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("WSEE Client Files Dir Exists: " + dir.exists()));
            this.getLog().debug((CharSequence)"FILES: ");
            if (dir.listFiles() != null) {
                for (File f : dir.listFiles()) {
                    this.getLog().debug((CharSequence)f.getAbsolutePath());
                }
            }
        }
        return dir.listFiles() != null ? dir.listFiles() : new File[]{};
    }

    public String getToolsJar() {
        return this.toolsJar;
    }

    public void setToolsJar(String toolsJar) {
        this.toolsJar = toolsJar;
    }

    public String toString() {
        return "AbstractWeblogicMojo{weblogicHome='" + this.weblogicHome + '\'' + ", artifacts=" + this.artifacts + ", dependencies=" + this.dependencies + ", pluginArtifacts=" + this.pluginArtifacts + ", outputDirectory='" + this.outputDirectory + '\'' + '}';
    }
}

