/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployMojoBase
extends AbstractWeblogicMojo {
    private String adminServerHostName;
    private String adminServerProtocol;
    private String adminServerPort;
    private String userId;
    private String password;
    private String artifactPath;
    private String projectPackaging;
    private String name;
    private String targetNames;
    private boolean remote;
    private boolean stage;
    private boolean debug;
    private boolean verbose;
    private boolean upload;
    private boolean exploded;
    private boolean deployEjb;
    private boolean skip;
    private String userConfigFile;
    private String userKeyFile;
    private boolean demoTrustKeyStore;
    private boolean ignoreHostnameVerification;
    private String customTrustKeyStoreFileName;
    private String customTrustKeyStorePassPhrase;
    private String customTrustKeyStoreType;
    private boolean continueOnFailure;
    private boolean noWait;
    private int timeout;
    private boolean version;
    private boolean noVersion;
    private boolean noExit;
    private String deploymentPlanPath;

    public String getAdminServerHostName() {
        return this.adminServerHostName;
    }

    public void setAdminServerHostName(String inAdminServerHostName) {
        this.adminServerHostName = inAdminServerHostName;
    }

    public String getAdminServerPort() {
        return this.adminServerPort;
    }

    public void setAdminServerPort(String inAdminServerPort) {
        this.adminServerPort = inAdminServerPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public String getTargetNames() {
        return this.targetNames;
    }

    public void setTargetNames(String inTargetNames) {
        this.targetNames = inTargetNames;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String inUserId) {
        this.userId = inUserId;
    }

    public boolean isIgnoreHostnameVerification() {
        return this.ignoreHostnameVerification;
    }

    public void setIgnoreHostnameVerification(boolean ignoreHostnameVerification) {
        this.ignoreHostnameVerification = ignoreHostnameVerification;
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.customTrustKeyStoreFileName;
    }

    public void setCustomTrustKeyStoreFileName(String customTrustKeyStoreFileName) {
        this.customTrustKeyStoreFileName = customTrustKeyStoreFileName;
    }

    public String getCustomTrustKeyStoreType() {
        return this.customTrustKeyStoreType;
    }

    public void setCustomTrustKeyStoreType(String customTrustKeyStoreType) {
        this.customTrustKeyStoreType = customTrustKeyStoreType;
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.customTrustKeyStorePassPhrase;
    }

    public void setCustomTrustKeyStorePassPhrase(String customTrustKeyStorePassPhrase) {
        this.customTrustKeyStorePassPhrase = customTrustKeyStorePassPhrase;
    }

    public List<String> getTargetList() {
        ArrayList<String> targets = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.getTargetNames(), ",");
        while (tokens.hasMoreTokens()) {
            targets.add(tokens.nextToken());
        }
        return targets;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean inRemote) {
        this.remote = inRemote;
    }

    public String getAdminServerProtocol() {
        return this.adminServerProtocol;
    }

    public void setAdminServerProtocol(String inAdminServerProtocol) {
        this.adminServerProtocol = inAdminServerProtocol;
    }

    public String getUserConfigFile() {
        return this.userConfigFile;
    }

    public void setUserConfigFile(String userConfigFile) {
        this.userConfigFile = userConfigFile;
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public void setUserKeyFile(String userKeyFile) {
        this.userKeyFile = userKeyFile;
    }

    public boolean isDemoTrustKeyStore() {
        return this.demoTrustKeyStore;
    }

    public void setDemoTrustKeyStore(boolean demoTrustKeyStore) {
        this.demoTrustKeyStore = demoTrustKeyStore;
    }

    protected String[] getInputParameters(String inOperation, String source, String name) {
        return this.getInputParameters(inOperation, source, name, null);
    }

    public void setDeploymentPlanPath(String deploymentPlanPath) {
        this.deploymentPlanPath = deploymentPlanPath;
    }

    protected String[] getInputParameters(String inOperation, String source, String name, String version) {
        ArrayList<String> parameterList = new ArrayList<String>();
        String adminURL = WeblogicMojoUtilities.getAdminUrl(this.adminServerProtocol, this.adminServerHostName, this.adminServerPort);
        if (this.isDebug()) {
            parameterList.add("-debug");
        }
        parameterList.add("-adminurl");
        parameterList.add(adminURL);
        if (this.getUserConfigFile() != null && this.getUserConfigFile().trim().length() > 0) {
            this.getLog().info((CharSequence)"Since user config file was specified, using that instead of username and password.");
            parameterList.add("-userconfigfile");
            parameterList.add(this.getUserConfigFile());
            if (this.getUserKeyFile() != null && this.getUserKeyFile().trim().length() > 0) {
                parameterList.add("-userkeyfile");
                parameterList.add(this.getUserKeyFile());
            }
        } else {
            parameterList.add("-username");
            parameterList.add(this.getUserId());
            parameterList.add("-password");
            parameterList.add(this.getPassword());
        }
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-name");
            parameterList.add(name != null && name.length() > 0 ? name : this.getName());
        }
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-targets");
            parameterList.add(this.getTargetNames());
        }
        if (inOperation.equalsIgnoreCase("deploy")) {
            if (this.isRemote()) {
                parameterList.add("-upload");
            }
            if (source != null && source.length() > 0) {
                parameterList.add("-source");
                parameterList.add(source);
            }
            if (version != null && version.length() > 0) {
                parameterList.add("-appversion");
                parameterList.add(version);
            }
        }
        String operation = "-" + inOperation;
        parameterList.add(operation);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("Weblogic Deployment parameters " + parameterList));
        }
        return parameterList.toArray(new String[parameterList.size()]);
    }

    public String getArtifactPath() {
        String fixedArtifactPath = this.exploded ? this.artifactPath : WeblogicMojoUtilities.updateArtifactName(this.artifactPath, this.projectPackaging);
        return fixedArtifactPath;
    }

    public void setArtifactPath(String inArtifactPath) {
        this.artifactPath = inArtifactPath;
    }

    public String getProjectPackaging() {
        return this.projectPackaging;
    }

    public void setProjectPackaging(String inProjectPackaging) {
        this.projectPackaging = inProjectPackaging;
    }

    @Override
    public String toString() {
        return "DeployMojoBase {adminServerHostName='" + this.adminServerHostName + '\'' + ", adminServerProtocol='" + this.adminServerProtocol + '\'' + ", adminServerPort='" + this.adminServerPort + '\'' + ", userId='" + this.userId + '\'' + ", password=******" + ", artifactPath='" + this.artifactPath + '\'' + ", projectPackaging='" + this.projectPackaging + '\'' + ", name='" + this.name + '\'' + ", targetNames='" + this.targetNames + '\'' + ", remote=" + this.remote + ", stage=" + this.stage + ", debug=" + this.debug + ", verbose=" + this.verbose + ", upload=" + this.upload + ", exploded=" + this.exploded + ", demoTrustKeyStore=" + this.demoTrustKeyStore + "} ";
    }

    public boolean isStage() {
        return this.stage;
    }

    public void setStage(boolean stage) {
        this.stage = stage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isUpload() {
        return this.upload;
    }

    public void setUpload(boolean upload) {
        this.upload = upload;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isNoVersion() {
        return this.noVersion;
    }

    public void setNoVersion(boolean noVersion) {
        this.noVersion = noVersion;
    }

    public boolean isNoExit() {
        return this.noExit;
    }

    public void setNoExit(boolean noExit) {
        this.noExit = noExit;
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public void setExploded(boolean exploded) {
        this.exploded = exploded;
    }

    protected String getSSLCommandLineArguments() throws MojoExecutionException {
        StringBuilder sb = new StringBuilder(128);
        if (this.debug) {
            sb.append(" -Dssl.debug=true ");
        }
        if (this.demoTrustKeyStore) {
            sb.append(" -Dweblogic.security.TrustKeyStore=DemoTrust ");
        } else if (this.customTrustKeyStoreFileName != null && this.customTrustKeyStoreFileName.length() > 0) {
            sb.append(" -Dweblogic.security.TrustKeyStore=CustomTrust ").append("-Dweblogic.security.CustomTrustKeyStoreFileName=").append(this.customTrustKeyStoreFileName).append(" -Dweblogic.security.TrustKeyStoreType=").append(this.customTrustKeyStoreType);
            if (this.customTrustKeyStorePassPhrase == null) {
                throw new MojoExecutionException("customTrustKeyStorePassPhrase is null");
            }
            sb.append(" -Dweblogic.security.CustomTrustKeystorePassPhrase=").append(this.customTrustKeyStorePassPhrase);
            if (this.ignoreHostnameVerification) {
                sb.append(" -Dweblogic.security.SSL.ignoreHostnameVerification=true ");
            }
        }
        if (this.ignoreHostnameVerification) {
            sb.append(" -Dweblogic.security.SSL.ignoreHostnameVerification=").append(String.valueOf(this.ignoreHostnameVerification).toLowerCase());
        }
        return sb.toString();
    }

    public Artifact[] getDeployableDependencyArtifacts() throws MojoExecutionException {
        if (this.getDependencies() == null || this.getDependencies().size() == 0) {
            return new Artifact[0];
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.getDependencies().size());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("there are " + this.getDependencies().size() + " to process."));
        }
        for (Dependency dependency : this.getDependencies()) {
            Artifact artifact = this.getArtifactFactory().createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType());
            if (this.skip) {
                if (!this.getLog().isInfoEnabled()) continue;
                this.getLog().info((CharSequence)("skipping dependency: " + artifact));
                continue;
            }
            if (("ear".equals(this.projectPackaging) || "war".equals(this.projectPackaging) || "pom".equals(this.projectPackaging) || "ejb".equals(this.projectPackaging)) && ("war".equals(artifact.getType()) || "ear".equals(artifact.getType()) || this.deployEjb && "ejb".equals(artifact.getType()))) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("adding dependency: " + artifact));
                }
                artifacts.add(artifact);
                continue;
            }
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("ignored dependency: " + artifact));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("returning " + artifacts.size() + " artifacts for the batch"));
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }
}

