/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.application.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.application.ApplicationServerException;
import org.codehaus.plexus.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.application.event.ApplicationListener;
import org.codehaus.plexus.application.event.DefaultDeployEvent;
import org.codehaus.plexus.application.profile.ApplicationRuntimeProfile;
import org.codehaus.plexus.application.service.PlexusService;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.Expand;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultApplicationDeployer
extends AbstractLogEnabled
implements ApplicationDeployer,
Contextualizable,
Initializable,
Disposable {
    private Map deployments;
    private DefaultPlexusContainer parentPlexus;
    private List applicationListeners;
    private String applicationsDirectory;
    private Properties contextValues;

    public void deploy(String name, String url) throws ApplicationServerException {
        URL location;
        try {
            location = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ApplicationServerException("Could not construct a URL from the string '" + url + "'.", e);
        }
        this.deploy(name, location);
    }

    public void deploy(String name, URL url) throws ApplicationServerException {
        if (!url.getProtocol().equals("file")) {
            throw new ApplicationServerException("Remote URLS not yet supported.");
        }
        if (!url.toString().endsWith(".jar")) {
            throw new ApplicationServerException("This deployer can only deploy *.jar files.");
        }
        File file = new File(url.getFile());
        try {
            this.deployJar(file, this.applicationsDirectory);
        }
        catch (IOException e) {
            throw new ApplicationServerException("Could not deploy the JAR.", e);
        }
        catch (XmlPullParserException e) {
            throw new ApplicationServerException("Could not deploy the JAR.", e);
        }
    }

    private void deployJar(File file, String directory) throws IOException, ApplicationServerException, XmlPullParserException {
        JarFile jarFile = new JarFile(file);
        ZipEntry entry = jarFile.getEntry("META-INF/plexus/application.xml");
        if (entry == null) {
            throw new ApplicationServerException("The Plexus application jar is missing it's metadata file 'META-INF/plexus/application.xml'.");
        }
        InputStreamReader reader = new InputStreamReader(jarFile.getInputStream(entry));
        Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
        String appId = dom.getChild("name").getValue();
        if (StringUtils.isEmpty((String)appId)) {
            throw new ApplicationServerException("Missing 'name' element in the application metadata file.");
        }
        File dest = new File(directory, appId);
        if (dest.exists()) {
            this.getLogger().info("Application '" + appId + "' already extracted.");
        } else {
            this.getLogger().info("Extracting " + file + " to '" + dest.getAbsolutePath() + "'.");
            Expand expander = new Expand();
            expander.setDest(dest);
            expander.setOverwrite(false);
            expander.setSrc(file);
            try {
                expander.execute();
            }
            catch (Exception e) {
                this.getLogger().error("Could not extract '" + file + "'.", (Throwable)e);
                return;
            }
        }
        try {
            this.deployApplicationDirectory(appId, dest);
        }
        catch (Exception e) {
            throw new ApplicationServerException("Could not deploy the JAR", e);
        }
    }

    protected void deployApplicationDirectory(String name, File location) throws Exception {
        int i;
        this.getLogger().info("Deploying application '" + name + "' at '" + location.getAbsolutePath() + "'.");
        if (this.deployments.containsKey(name)) {
            throw new ApplicationServerException("A application with the specified name ('" + name + "') already exists.");
        }
        File applicationConfigurationFile = new File(new File(location, "conf"), "application.xml");
        if (!applicationConfigurationFile.exists()) {
            throw new ApplicationServerException("The application '" + name + "' does not have a valid " + "configuration: " + applicationConfigurationFile + " does not exist!");
        }
        File applicationLibrary = new File(location, "lib");
        if (!applicationLibrary.exists()) {
            throw new ApplicationServerException("The application '" + name + "' does not have a valid library: " + applicationLibrary + " does not exist!");
        }
        DefaultPlexusContainer applicationContainer = new DefaultPlexusContainer();
        FileInputStream stream = new FileInputStream(applicationConfigurationFile);
        InputStreamReader r = new InputStreamReader(stream);
        applicationContainer.setConfigurationResource((Reader)r);
        if (this.contextValues != null) {
            Iterator i2 = ((Hashtable)this.contextValues).keySet().iterator();
            while (i2.hasNext()) {
                String contextName = (String)i2.next();
                applicationContainer.addContextValue((Object)contextName, (Object)this.contextValues.getProperty(contextName));
            }
        }
        applicationContainer.addContextValue((Object)"plexus.home", (Object)location.getAbsolutePath());
        applicationContainer.setParentPlexusContainer((PlexusContainer)this.parentPlexus);
        applicationContainer.setClassWorld(this.parentPlexus.getClassWorld());
        ClassRealm realm = this.parentPlexus.getCoreRealm().createChildRealm("plexus.application." + name);
        applicationContainer.setCoreRealm(realm);
        ContextMapAdapter context = new ContextMapAdapter(applicationContainer.getContext());
        InterpolationFilterReader configurationReader = new InterpolationFilterReader((Reader)new FileReader(applicationConfigurationFile), (Map)context);
        Xpp3Dom dom = Xpp3DomBuilder.build((Reader)configurationReader);
        XmlPlexusConfiguration applicationConfiguration = new XmlPlexusConfiguration(dom);
        ApplicationRuntimeProfile profile = new ApplicationRuntimeProfile(name, location, applicationLibrary, applicationContainer, (PlexusConfiguration)applicationConfiguration);
        PlexusConfiguration[] services = applicationConfiguration.getChild("services").getChildren("service");
        for (i = 0; i < services.length; ++i) {
            PlexusConfiguration serviceConfiguration = services[i];
            String id = serviceConfiguration.getChild("id").getValue();
            if (StringUtils.isEmpty((String)id)) {
                throw new Exception("Missing child element 'id' in 'service'.");
            }
            if (!this.parentPlexus.hasComponent(PlexusService.ROLE, id)) {
                this.getLogger().error("Error while loading plexus service with id '" + id + "'. " + "The service doesn't exists.");
                continue;
            }
            Object serviceObject = this.parentPlexus.lookup(PlexusService.ROLE, id);
            if (!(serviceObject instanceof PlexusService)) {
                this.getLogger().error("Error while loading plexus service with id '" + id + "'. " + "The component has to implement the PlexusService interface.");
                continue;
            }
            PlexusService service = (PlexusService)serviceObject;
            profile.getServices().add(service);
            PlexusConfiguration conf = serviceConfiguration.getChild("configuration");
            profile.getServiceConfigurations().add(conf);
            service.beforeApplicationStart(profile, conf);
        }
        try {
            applicationContainer.initialize();
            applicationContainer.start();
        }
        catch (Exception e) {
            throw new Exception("Error starting Plexus.", e);
        }
        this.deployments.put(name, profile);
        for (i = 0; i < profile.getServices().size(); ++i) {
            PlexusService service = (PlexusService)profile.getServices().get(i);
            PlexusConfiguration configuration = (PlexusConfiguration)profile.getServiceConfigurations().get(i);
            service.afterApplicationStart(profile, configuration);
        }
    }

    public void redeploy(String name, String url) throws ApplicationServerException {
        ApplicationRuntimeProfile profile = this.getApplicationRuntimeProfile(name);
        this.undeploy(name);
        this.deploy(name, url);
        DefaultDeployEvent event = this.createDeployEvent(profile);
        Iterator itr = this.applicationListeners.iterator();
        while (itr.hasNext()) {
            ApplicationListener listener = (ApplicationListener)itr.next();
            listener.redeployedApplication(event);
        }
    }

    public void undeploy(String name) throws ApplicationServerException {
        this.getLogger().info("Undeploying '" + name + "'.");
        ApplicationRuntimeProfile profile = this.getApplicationRuntimeProfile(name);
        this.deployments.remove(name);
        DefaultPlexusContainer app = profile.getContainer();
        app.dispose();
        ClassRealm realm = app.getCoreRealm();
        try {
            realm.getWorld().disposeRealm(realm.getId());
        }
        catch (NoSuchRealmException e) {
            this.getLogger().warn("Error while disposing application realm '" + realm.getId() + "'");
        }
        DefaultDeployEvent event = this.createDeployEvent(profile);
        Iterator itr = this.applicationListeners.iterator();
        while (itr.hasNext()) {
            ApplicationListener listener = (ApplicationListener)itr.next();
            listener.undeployedApplication(event);
        }
    }

    private DefaultDeployEvent createDeployEvent(ApplicationRuntimeProfile runtimeProfile) {
        DefaultDeployEvent event = new DefaultDeployEvent(runtimeProfile);
        return event;
    }

    public ApplicationRuntimeProfile getApplicationRuntimeProfile(String applicationName) throws ApplicationServerException {
        ApplicationRuntimeProfile profile = (ApplicationRuntimeProfile)this.deployments.get(applicationName);
        if (profile == null) {
            throw new ApplicationServerException("No such application: '" + applicationName + "'.");
        }
        return profile;
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.applicationListeners.remove(listener);
    }

    public void contextualize(Context context) throws ContextException {
        this.parentPlexus = (DefaultPlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        this.deployments = new HashMap();
        this.applicationListeners = new ArrayList();
        this.getLogger().info("Applications will be deployed in: '" + this.applicationsDirectory + "'.");
    }

    public void dispose() {
        ArrayList names = new ArrayList(this.deployments.keySet());
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                this.undeploy(name);
            }
            catch (Exception e) {
                this.getLogger().warn("Error while undeploying application '" + name + "'.", (Throwable)e);
            }
        }
    }
}

