/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.merge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.codehaus.plexus.metadata.merge.Driver;
import org.codehaus.plexus.metadata.merge.MergeException;
import org.codehaus.plexus.metadata.merge.Merger;
import org.codehaus.plexus.util.IOUtil;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractMerger
implements Merger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMergedDocument(Document mergedDocument, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        XMLOutputter out = new XMLOutputter();
        OutputStreamWriter fw = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            out.output(mergedDocument, (Writer)fw);
        }
        catch (Throwable throwable) {
            IOUtil.close(fw);
            throw throwable;
        }
        IOUtil.close((Writer)fw);
    }

    @Override
    public void mergeDescriptors(File outputDescriptor, List<File> descriptors) throws IOException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)new XMLReaderSAX2Factory(false, Driver.class.getName()));
        Document finalDoc = null;
        for (File f : descriptors) {
            try {
                Document doc = builder.build(f);
                if (finalDoc != null) {
                    finalDoc = this.merge(doc, finalDoc);
                    continue;
                }
                finalDoc = doc;
            }
            catch (JDOMException e) {
                throw new IOException("Invalid input descriptor for merge: " + f + " --> " + e.getMessage());
            }
            catch (MergeException e) {
                throw new IOException("Error merging descriptor: " + f + " --> " + e.getMessage());
            }
        }
        if (finalDoc != null) {
            try {
                this.writeMergedDocument(finalDoc, outputDescriptor);
            }
            catch (IOException e) {
                throw new IOException("Error writing merged descriptor: " + outputDescriptor);
            }
        }
    }
}

