/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentDiscoverer
implements ComponentDiscoverer {
    private ComponentDiscovererManager manager;

    protected abstract String getComponentDescriptorLocation();

    protected abstract ComponentSetDescriptor createComponentDescriptors(Reader var1, String var2) throws PlexusConfigurationException;

    @Override
    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }

    @Override
    public List<ComponentSetDescriptor> findComponents(Context context, ClassRealm realm) throws PlexusConfigurationException {
        Enumeration resources;
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        try {
            resources = realm.getParentRealm() != null ? realm.findRealmResources(this.getComponentDescriptorLocation()) : realm.findResources(this.getComponentDescriptorLocation());
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Unable to retrieve resources for: " + this.getComponentDescriptorLocation() + " in class realm: " + realm.getId());
        }
        for (URL url : Collections.list(resources)) {
            XmlStreamReader reader = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                reader = ReaderFactory.newXmlReader((InputStream)conn.getInputStream());
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, (Map)new ContextMapAdapter(context));
                ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors((Reader)interpolationFilterReader, url.toString());
                if (componentSetDescriptor.getComponents() != null) {
                    for (ComponentDescriptor<?> cd : componentSetDescriptor.getComponents()) {
                        cd.setComponentSetDescriptor(componentSetDescriptor);
                        cd.setRealm(realm);
                    }
                }
                componentSetDescriptors.add(componentSetDescriptor);
                ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
                this.manager.fireComponentDiscoveryEvent(event);
            }
            catch (IOException ex) {
                try {
                    throw new PlexusConfigurationException("Error reading configuration " + url, ex);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        return componentSetDescriptors;
    }
}

