/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.JarHolder;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;

@Component(role=ResourceLoader.class, hint="jar", instantiationStrategy="per-lookup")
public class JarResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "jar";
    private Map entryDirectory = new LinkedHashMap(559);
    private Map<String, JarHolder> jarfiles = new LinkedHashMap<String, JarHolder>(89);
    private boolean initializeCalled;

    public void initialize() throws InitializationException {
        this.initializeCalled = true;
        if (this.paths != null) {
            for (int i = 0; i < this.paths.size(); ++i) {
                this.loadJar((String)this.paths.get(i));
            }
        }
    }

    private void loadJar(String path) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JarResourceLoader : trying to load \"" + path + "\"");
        }
        if (path == null) {
            this.getLogger().error("JarResourceLoader : can not load JAR - JAR path is null");
            return;
        }
        if (!path.startsWith("jar:")) {
            this.getLogger().error("JarResourceLoader : JAR path must start with jar: -> see java.net.JarURLConnection for information");
            return;
        }
        if (!path.endsWith("!/")) {
            path = path + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(path);
        this.addEntries(temp.getEntries());
        this.jarfiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarfiles.containsKey(path)) {
            JarHolder theJar = this.jarfiles.get(path);
            theJar.close();
        }
    }

    private void addEntries(Map entries) {
        this.entryDirectory.putAll(entries);
    }

    public PlexusResource getResource(String source) throws ResourceNotFoundException {
        String jarurl;
        JarHolder holder;
        if (!this.initializeCalled) {
            try {
                this.initialize();
            }
            catch (InitializationException e) {
                throw new ResourceNotFoundException(e.getMessage(), e);
            }
        }
        if (source == null || source.length() == 0) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        if (source.startsWith("/")) {
            source = source.substring(1);
        }
        if (this.entryDirectory.containsKey(source) && (holder = this.jarfiles.get(jarurl = (String)this.entryDirectory.get(source))) != null) {
            return holder.getPlexusResource(source);
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + source);
    }

    public void addSearchPath(String path) {
        if (!this.paths.contains(path)) {
            if (this.initializeCalled) {
                this.loadJar(path);
            }
            this.paths.add(path);
        }
    }
}

