/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.builder;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractBuilder
extends AbstractLogEnabled {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder projectBuilder;
    private ArtifactMetadataSource metadata;

    protected void executable(File file) throws CommandLineException, IOException {
        if (Os.isFamily((String)"unix")) {
            Commandline cli = new Commandline();
            cli.setExecutable("chmod");
            cli.createArgument().setValue("+x");
            cli.createArgument().setValue(file.getAbsolutePath());
            cli.execute();
        }
    }

    protected File mkdirs(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not make directories '" + directory.getAbsolutePath() + "'.");
        }
        return directory;
    }

    protected InputStream getResourceAsStream(String resource) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("Could not find resource '" + resource + "'.");
        }
        return is;
    }

    protected void filterCopy(File in, File out, Map map) throws IOException {
        this.filterCopy(new FileReader(in), out, map);
    }

    protected void filterCopy(InputStream in, File out, Map map) throws IOException {
        this.filterCopy(new InputStreamReader(in), out, map);
    }

    protected void filterCopy(Reader in, File out, Map map) throws IOException {
        InterpolationFilterReader reader = new InterpolationFilterReader(in, map, "@", "@");
        FileWriter writer = new FileWriter(out);
        IOUtil.copy((Reader)reader, (Writer)writer);
        ((Writer)writer).close();
    }

    protected void copyArtifact(Artifact artifact, File outputDir, File destination) throws IOException {
        String dest = destination.getAbsolutePath().substring(outputDir.getAbsolutePath().length() + 1);
        this.getLogger().info("Adding " + artifact.getId() + " to " + dest);
        FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)destination);
    }

    protected void copyArtifacts(File outputDir, File dir, Set artifacts) throws IOException {
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.copyArtifact(artifact, outputDir, dir);
        }
    }

    protected Set getBootArtifacts(Set projectArtifacts, List remoteRepositories, ArtifactRepository localRepository, boolean ignoreIfMissing) throws ArtifactResolutionException {
        Set artifacts = new HashSet();
        this.resolveVersion("classworlds", "classworlds", projectArtifacts, ignoreIfMissing, artifacts);
        artifacts = this.findArtifacts(remoteRepositories, localRepository, artifacts, false, null);
        return artifacts;
    }

    protected Set getCoreArtifacts(Set projectArtifacts, List remoteRepositories, ArtifactRepository localRepository, boolean ignoreIfMissing) throws ArtifactResolutionException {
        Set artifacts = new HashSet();
        this.resolveVersion("org.codehaus.plexus", "plexus-container-default", projectArtifacts, ignoreIfMissing, artifacts);
        this.resolveVersion("plexus", "plexus-container-artifact", projectArtifacts, ignoreIfMissing, artifacts);
        this.resolveVersion("org.codehaus.plexus", "plexus-appserver", projectArtifacts, ignoreIfMissing, artifacts);
        this.resolveVersion("org.codehaus.plexus", "plexus-utils", projectArtifacts, ignoreIfMissing, artifacts);
        artifacts = this.findArtifacts(remoteRepositories, localRepository, artifacts, false, null);
        return artifacts;
    }

    protected Set getExcludedArtifacts(Set projectArtifacts, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException {
        Set artifacts = new HashSet();
        this.resolveVersion("plexus", "plexus", projectArtifacts, true, artifacts);
        this.resolveVersion("plexus", "plexus-container-api", projectArtifacts, true, artifacts);
        this.resolveVersion("plexus", "plexus-container-default", projectArtifacts, true, artifacts);
        this.resolveVersion("plexus", "plexus-appserver", projectArtifacts, true, artifacts);
        this.resolveVersion("plexus", "plexus-utils", projectArtifacts, true, artifacts);
        artifacts = this.findArtifacts(remoteRepositories, localRepository, artifacts, true, null);
        return artifacts;
    }

    protected Set findArtifacts(List remoteRepositories, ArtifactRepository localRepository, Set sourceArtifacts, boolean resolveTransitively, ArtifactFilter artifactFilter) throws ArtifactResolutionException {
        Set<Artifact> resolvedArtifacts;
        Artifact originatingArtifact = this.artifactFactory.createProjectArtifact("dummy", "dummy", "dummy");
        if (resolveTransitively) {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(sourceArtifacts, originatingArtifact, localRepository, remoteRepositories, this.metadata, artifactFilter);
            resolvedArtifacts = result.getArtifacts();
        } else {
            resolvedArtifacts = new HashSet();
            Iterator it = sourceArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
                resolvedArtifacts.add(artifact);
            }
        }
        return resolvedArtifacts;
    }

    protected String resolveVersion(String groupId, String artifactId, Set projectArtifacts, boolean ignoreIfMissing, Set resolvedArtifacts) {
        Iterator it = projectArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId) || !artifact.getType().equals("jar")) continue;
            resolvedArtifacts.add(artifact);
            return artifact.getVersion();
        }
        if (!ignoreIfMissing) {
            throw new RuntimeException("Could not version for artifact: " + groupId + ":" + artifactId + ".");
        }
        return null;
    }

    public static class AndArtifactFilter
    implements ArtifactFilter {
        private ArtifactFilter filterA;
        private ArtifactFilter filterB;

        public AndArtifactFilter(ArtifactFilter filterA, ArtifactFilter filterB) {
            this.filterA = filterA;
            this.filterB = filterB;
        }

        public boolean include(Artifact artifact) {
            return this.filterA.include(artifact) && this.filterB.include(artifact);
        }
    }

    public static class GroupArtifactTypeArtifactFilter
    implements ArtifactFilter {
        private Set filteredArtifacts;

        public GroupArtifactTypeArtifactFilter(Set filteredArtifacts) {
            this.filteredArtifacts = filteredArtifacts;
        }

        public boolean include(Artifact candiateArtifact) {
            Iterator it = this.filteredArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                if (!candiateArtifact.getGroupId().equals(artifact.getGroupId()) || !candiateArtifact.getArtifactId().equals(artifact.getArtifactId()) || !candiateArtifact.getType().equals(artifact.getType())) continue;
                return false;
            }
            return true;
        }
    }

    public static class ScopeExcludeArtifactFilter
    implements ArtifactFilter {
        private String scope;

        public ScopeExcludeArtifactFilter(String scope) {
            this.scope = scope;
        }

        public boolean include(Artifact artifact) {
            return !this.scope.equals(artifact.getScope());
        }
    }
}

