/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.xmlrpc;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StoppingException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.xmlrpc.Client;
import org.codehaus.plexus.xmlrpc.Handler;
import org.codehaus.plexus.xmlrpc.XmlRpcComponent;
import org.codehaus.plexus.xmlrpc.XmlRpcMessageListener;
import org.codehaus.plexus.xmlrpc.XmlRpcServer;

public class DefaultXmlRpcComponent
extends AbstractLogEnabled
implements Contextualizable,
Initializable,
Startable,
XmlRpcComponent {
    private PlexusContainer container;
    private int port;
    private boolean isSecureServer;
    private String saxParserClass;
    private boolean paranoid;
    private List handlers;
    private List acceptedClients;
    private List deniedClients;
    private Properties systemProperties;
    private List listeners = new ArrayList();
    private boolean isInitialized = false;
    private XmlRpcServer xmlRpcServer;
    static /* synthetic */ Class class$org$codehaus$plexus$xmlrpc$Client;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        this.setSystemPropertiesFromConfiguration();
        if (this.port == 0) {
            this.port = 8080;
        }
        this.getLogger().info("Initializing the XML-RPC server on port " + this.port + ".");
        try {
            this.xmlRpcServer.addListener(null, this.port, this.isSecureServer);
        }
        catch (XmlRpcException e) {
            throw new InitializationException("Cannot add listener on port " + this.port + " [isSecureServer=" + this.isSecureServer + "]", (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)this.saxParserClass)) {
            try {
                XmlRpc.setDriver((String)this.saxParserClass);
            }
            catch (ClassNotFoundException e) {
                throw new InitializationException("Cannot find the specified SAX parser class: " + this.saxParserClass);
            }
        }
        try {
            this.registerStartupHandlers();
        }
        catch (Exception e) {
            throw new InitializationException("Cannot register startup handlers: ", (Throwable)e);
        }
        if (this.paranoid) {
            String clientIP;
            int i;
            this.getLogger().info("Operating in a state of paranoia");
            if (this.acceptedClients == null) {
                throw new InitializationException("When in state of paranoia a list of 'acceptedClients' is required.");
            }
            for (i = 0; i < this.acceptedClients.size(); ++i) {
                clientIP = this.getClient(this.acceptedClients, i);
                this.xmlRpcServer.acceptClient(clientIP);
                this.getLogger().info("Accepting client -> " + clientIP);
            }
            if (this.deniedClients == null) {
                throw new InitializationException("When in state of paranoia a list of 'deniedClients' is required.");
            }
            for (i = 0; i < this.deniedClients.size(); ++i) {
                clientIP = this.getClient(this.acceptedClients, i);
                this.xmlRpcServer.denyClient(clientIP);
                this.getLogger().info("Denying client -> " + clientIP);
            }
        }
        this.isInitialized = true;
    }

    public void start() throws StartingException {
        try {
            this.xmlRpcServer.startListener(null, this.port);
        }
        catch (XmlRpcException e) {
            throw new StartingException("Cannot start xmlrpc server: ", (Throwable)e);
        }
    }

    public void stop() throws StoppingException {
        try {
            this.xmlRpcServer.removeListener(null, this.port);
        }
        catch (XmlRpcException e) {
            throw new StoppingException("Cannot stop xmlrpc server: ", (Throwable)e);
        }
    }

    private void registerStartupHandlers() throws Exception {
        if (this.handlers == null) {
            this.getLogger().warn("No handlers to configure.");
            return;
        }
        this.getLogger().info("There are " + this.handlers.size() + " handlers to configure.");
        for (int i = 0; i < this.handlers.size(); ++i) {
            Object obj = this.handlers.get(i);
            if (!(obj instanceof Handler)) {
                this.getLogger().warn("Unknown object type in the handler array: " + obj.getClass().getName());
                continue;
            }
            Handler handler = (Handler)obj;
            String name = handler.getName();
            String role = handler.getRole();
            if (name == null) {
                throw new PlexusConfigurationException("Missing required configuration element: 'name' in 'handler'.");
            }
            if (name.trim().length() == 0) {
                throw new PlexusConfigurationException("The 'name' element of a 'handler' cant be empty.");
            }
            if (role == null) {
                throw new PlexusConfigurationException("Missing required configuration element: 'role' in 'handler'.");
            }
            if (role.trim().length() == 0) {
                throw new PlexusConfigurationException("The 'role element of a 'handler' cant be empty.");
            }
            this.registerComponentHandler(name, role);
        }
    }

    public void registerHandler(Object handler) throws XmlRpcException, IOException {
        this.registerHandler("$default", handler);
    }

    public void registerHandler(String handlerName, Object handler) throws XmlRpcException, IOException {
        this.xmlRpcServer.addHandler(handlerName, handler);
    }

    private void registerComponentHandler(String handlerName, String handlerRole) throws Exception {
        this.registerHandler(handlerName, this.container.lookup(handlerRole));
        this.getLogger().info("registered: " + handlerName + " with component: " + handlerRole);
    }

    public void unregisterHandler(String handlerName) throws XmlRpcException {
        this.xmlRpcServer.removeHandler(handlerName);
    }

    public Object executeRpc(URL url, String methodName, Vector params) throws Exception {
        try {
            XmlRpcClient client = new XmlRpcClient(url);
            return client.execute(methodName, params);
        }
        catch (Exception e) {
            throw new Exception("XML-RPC call failed", e);
        }
    }

    public void setParanoid(boolean state) {
        if (this.isInitialized) {
            this.xmlRpcServer.setParanoid(null, this.port, state);
        } else {
            this.paranoid = state;
        }
    }

    public void acceptClient(String address) {
        this.xmlRpcServer.acceptClient(address);
    }

    public void denyClient(String address) {
        this.xmlRpcServer.denyClient(address);
    }

    public void addMessageListener(XmlRpcMessageListener listener) {
        this.listeners.add(listener);
    }

    public void messageReceived(String message) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            XmlRpcMessageListener listener = (XmlRpcMessageListener)i.next();
            listener.xmlRpcMessageReceived(message);
        }
    }

    private void setSystemPropertiesFromConfiguration() {
        if (this.systemProperties == null) {
            return;
        }
        Enumeration<?> e = this.systemProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = this.systemProperties.getProperty(key);
            System.setProperty(key, value);
            this.getLogger().debug("Setting property: " + key + " => '" + value + "'.");
        }
    }

    private String getClient(List list, int index) throws InitializationException {
        Object obj = list.get(index);
        if (!(obj instanceof Client)) {
            throw new InitializationException("The client address element must be a '" + (class$org$codehaus$plexus$xmlrpc$Client == null ? (class$org$codehaus$plexus$xmlrpc$Client = DefaultXmlRpcComponent.class$("org.codehaus.plexus.xmlrpc.Client")) : class$org$codehaus$plexus$xmlrpc$Client).getName() + "'.");
        }
        Client client = (Client)obj;
        return client.getHostname();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

