/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.AbstractCoverageExtension;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.surefire.api.AbstractSurefireParser;
import org.sonar.plugins.surefire.api.SurefireUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireSensor
implements Sensor {
    private static Logger logger = LoggerFactory.getLogger(SurefireSensor.class);

    @DependsUpon
    public Class<?> dependsUponCoverageSensors() {
        return AbstractCoverageExtension.class;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().isDynamic(true) && "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        File dir = SurefireUtils.getReportsDirectory(project);
        this.collect(project, context, dir);
    }

    protected void collect(Project project, SensorContext context, File reportsDir) {
        logger.info("parsing {}", (Object)reportsDir);
        new AbstractSurefireParser(){

            @Override
            protected Resource<?> getUnitTestResource(String classKey) {
                return new JavaFile(classKey, true);
            }
        }.collect(project, context, reportsDir);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

