/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.surefire.TestCaseDetails;
import org.sonar.plugins.surefire.TestSuiteReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteParser
implements StaxParser.XmlStreamHandler {
    private Map<String, TestSuiteReport> reportsPerClass = new HashMap<String, TestSuiteReport>();

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMEvent testSuiteEvent;
        SMInputCursor testSuite = rootCursor.constructDescendantCursor((SMFilter)new ElementFilter("testsuite"));
        while ((testSuiteEvent = testSuite.getNext()) != null) {
            SMEvent event;
            if (testSuiteEvent.compareTo((Enum)SMEvent.START_ELEMENT) != 0) continue;
            String testSuiteClassName = testSuite.getAttrValue("name");
            if (StringUtils.contains((String)testSuiteClassName, (String)"$")) {
                return;
            }
            SMInputCursor testCase = testSuite.childCursor((SMFilter)new ElementFilter("testcase"));
            while ((event = testCase.getNext()) != null) {
                if (event.compareTo((Enum)SMEvent.START_ELEMENT) != 0) continue;
                String testClassName = this.getClassname(testCase, testSuiteClassName);
                TestSuiteReport report = this.reportsPerClass.get(testClassName);
                if (report == null) {
                    report = new TestSuiteReport(testClassName);
                    this.reportsPerClass.put(testClassName, report);
                }
                this.cumulateTestCaseDetails(testCase, report);
            }
        }
    }

    public Collection<TestSuiteReport> getParsedReports() {
        return this.reportsPerClass.values();
    }

    private String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        String testClassName = testCaseCursor.getAttrValue("classname");
        return (testClassName = StringUtils.substringBeforeLast((String)testClassName, (String)"$")) == null ? defaultClassname : testClassName;
    }

    private void cumulateTestCaseDetails(SMInputCursor testCaseCursor, TestSuiteReport report) throws XMLStreamException {
        TestCaseDetails detail = this.getTestCaseDetails(testCaseCursor);
        if (detail.getStatus().equals("skipped")) {
            report.setSkipped(report.getSkipped() + 1);
        } else if (detail.getStatus().equals("failure")) {
            report.setFailures(report.getFailures() + 1);
        } else if (detail.getStatus().equals("error")) {
            report.setErrors(report.getErrors() + 1);
        }
        report.setTests(report.getTests() + 1);
        report.setTimeMS(report.getTimeMS() + detail.getTimeMS());
        report.getDetails().add(detail);
    }

    private void setStackAndMessage(TestCaseDetails detail, SMInputCursor stackAndMessageCursor) throws XMLStreamException {
        detail.setErrorMessage(stackAndMessageCursor.getAttrValue("message"));
        String stack = stackAndMessageCursor.collectDescendantText();
        detail.setStackTrace(stack);
    }

    private TestCaseDetails getTestCaseDetails(SMInputCursor testCaseCursor) throws XMLStreamException {
        TestCaseDetails detail = new TestCaseDetails();
        String name = this.getTestCaseName(testCaseCursor);
        detail.setName(name);
        String status = "ok";
        Double time = this.getTimeAttributeInMS(testCaseCursor);
        SMInputCursor childNode = testCaseCursor.descendantElementCursor();
        if (childNode.getNext() != null) {
            String elementName = childNode.getLocalName();
            if (elementName.equals("skipped")) {
                status = "skipped";
                time = 0.0;
            } else if (elementName.equals("failure")) {
                status = "failure";
                this.setStackAndMessage(detail, childNode);
            } else if (elementName.equals("error")) {
                status = "error";
                this.setStackAndMessage(detail, childNode);
            }
        }
        while (childNode.getNext() != null) {
        }
        detail.setTimeMS(time.intValue());
        detail.setStatus(status);
        return detail;
    }

    private Double getTimeAttributeInMS(SMInputCursor testCaseCursor) throws XMLStreamException {
        try {
            Double time = ParsingUtils.parseNumber((String)testCaseCursor.getAttrValue("time"), (Locale)Locale.ENGLISH);
            return !Double.isNaN(time) ? ParsingUtils.scaleValue((double)(time * 1000.0), (int)3) : 0.0;
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
    }

    private String getTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String classname = testCaseCursor.getAttrValue("classname");
        String name = testCaseCursor.getAttrValue("name");
        if (StringUtils.contains((String)classname, (String)"$")) {
            return StringUtils.substringAfterLast((String)classname, (String)"$") + "/" + name;
        }
        return name;
    }
}

