/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinitions
implements BatchComponent,
ServerComponent {
    private final Map<String, PropertyDefinition> definitions = Maps.newHashMap();
    private final Map<String, String> categories = Maps.newHashMap();

    public PropertyDefinitions(Object ... components) {
        if (components != null) {
            this.addComponents(Arrays.asList(components));
        }
    }

    public PropertyDefinitions addComponents(Collection components) {
        return this.addComponents(components, "");
    }

    public PropertyDefinitions addComponents(Collection components, String defaultCategory) {
        for (Object component : components) {
            this.addComponent(component, defaultCategory);
        }
        return this;
    }

    public PropertyDefinitions addComponent(Object object) {
        return this.addComponent(object, "");
    }

    public PropertyDefinitions addComponent(Object component, String defaultCategory) {
        Property annotation;
        Properties annotations = AnnotationUtils.getAnnotation(component, Properties.class);
        if (annotations != null) {
            for (Property property : annotations.value()) {
                this.addProperty(property, defaultCategory);
            }
        }
        if ((annotation = AnnotationUtils.getAnnotation(component, Property.class)) != null) {
            this.addProperty(annotation, defaultCategory);
        }
        return this;
    }

    private PropertyDefinitions addProperty(Property property, String defaultCategory) {
        PropertyDefinition definition = PropertyDefinition.create(property);
        return this.add(definition, defaultCategory);
    }

    private PropertyDefinitions add(PropertyDefinition definition, String defaultCategory) {
        if (!this.definitions.containsKey(definition.getKey())) {
            this.definitions.put(definition.getKey(), definition);
            this.categories.put(definition.getKey(), StringUtils.defaultIfBlank((String)definition.getCategory(), (String)defaultCategory));
        }
        return this;
    }

    public PropertyDefinition get(String key) {
        return this.definitions.get(key);
    }

    public Collection<PropertyDefinition> getAll() {
        return this.definitions.values();
    }

    private Map<String, Collection<PropertyDefinition>> getPropertiesByCategory(PropertyDefinitionFilter filter) {
        ArrayListMultimap byCategory = ArrayListMultimap.create();
        for (PropertyDefinition definition : this.getAll()) {
            if (!filter.accept(definition)) continue;
            byCategory.put((Object)this.getCategory(definition.getKey()), (Object)definition);
        }
        return byCategory.asMap();
    }

    public Map<String, Collection<PropertyDefinition>> getGlobalPropertiesByCategory() {
        return this.getPropertiesByCategory(PropertyDefinitionFilter.GLOBAL);
    }

    public Map<String, Collection<PropertyDefinition>> getProjectPropertiesByCategory() {
        return this.getPropertiesByCategory(PropertyDefinitionFilter.PROJECT);
    }

    public Map<String, Collection<PropertyDefinition>> getModulePropertiesByCategory() {
        return this.getPropertiesByCategory(PropertyDefinitionFilter.MODULE);
    }

    public String getDefaultValue(String key) {
        PropertyDefinition def = this.get(key);
        if (def == null) {
            return null;
        }
        return StringUtils.defaultIfEmpty((String)def.getDefaultValue(), null);
    }

    public String getCategory(String key) {
        return this.categories.get(key);
    }

    public String getCategory(Property prop) {
        return this.getCategory(prop.key());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyDefinitionFilter {
        GLOBAL{

            boolean accept(PropertyDefinition propertyDefinition) {
                return propertyDefinition.isGlobal();
            }
        }
        ,
        PROJECT{

            boolean accept(PropertyDefinition propertyDefinition) {
                return propertyDefinition.isOnProject();
            }
        }
        ,
        MODULE{

            boolean accept(PropertyDefinition propertyDefinition) {
                return propertyDefinition.isOnModule();
            }
        };


        abstract boolean accept(PropertyDefinition var1);
    }
}

