/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.aegis.type.basic.ObjectType;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBindingProvider;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.SchemaType;

public class AegisBindingProvider
extends AbstractBindingProvider {
    public static final Log LOG = LogFactory.getLog((Class)AegisBindingProvider.class);
    public static final String CURRENT_MESSAGE_PART = "currentMessagePart";
    public static final String TYPE_MAPPING_KEY = "type.mapping";
    public static final String ENCODING_URI_KEY = "type.encodingUri";
    public static final String WRITE_XSI_TYPE_KEY = "writeXsiType";
    public static final String OVERRIDE_TYPES_KEY = "overrideTypesList";
    private TypeMappingRegistry registry;
    private Map part2type = new HashMap();

    public AegisBindingProvider() {
        this(new DefaultTypeMappingRegistry(true));
    }

    public AegisBindingProvider(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.registry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public void initialize(Service service) {
        List classes = (List)service.getProperty(OVERRIDE_TYPES_KEY);
        if (classes != null) {
            System.out.println("INITING TYPES");
            ArrayList<BeanType> types = new ArrayList<BeanType>();
            TypeMapping tm = this.getTypeMapping(service);
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                Class c;
                String typeName = (String)it.next();
                try {
                    c = ClassLoaderUtils.loadClass((String)typeName, (Class)(class$org$codehaus$xfire$aegis$AegisBindingProvider == null ? AegisBindingProvider.class$("org.codehaus.xfire.aegis.AegisBindingProvider") : class$org$codehaus$xfire$aegis$AegisBindingProvider));
                }
                catch (ClassNotFoundException e) {
                    throw new XFireRuntimeException("Could not find override type class: " + typeName, (Throwable)e);
                }
                Type t = tm.getType(c);
                if (t == null) {
                    t = tm.getTypeCreator().createType(c);
                    tm.register(t);
                }
                if (!(t instanceof BeanType)) continue;
                BeanType bt = (BeanType)t;
                bt.getTypeInfo().setExtension(true);
                types.add(bt);
            }
            service.setProperty("overridingTypes", types);
        }
        super.initialize(service);
    }

    protected void initializeMessage(Service service, MessagePartContainer container, int type) {
        Iterator itr = container.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            if (part.getSchemaType() != null) continue;
            part.setSchemaType((SchemaType)this.getParameterType(this.getTypeMapping(service), part, type));
        }
    }

    public Object readParameter(MessagePartInfo p, XMLStreamReader xsr, MessageContext context) throws XFireFault {
        Type type = this.getTypeMapping(context.getService()).getType(xsr.getName());
        if (type == null) {
            type = (Type)p.getSchemaType();
        }
        type = AegisBindingProvider.getReadType(xsr, context, type);
        ElementReader reader = new ElementReader(xsr);
        if (reader.isXsiNil()) {
            reader.readToEnd();
            return null;
        }
        context.setProperty(CURRENT_MESSAGE_PART, (Object)p);
        return type.readObject(reader, context);
    }

    public static Type getReadType(XMLStreamReader xsr, MessageContext context, Type type) {
        QName overrideTypeName;
        String overrideType = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (overrideType != null && !(overrideTypeName = NamespaceHelper.createQName((NamespaceContext)xsr.getNamespaceContext(), (String)overrideType)).equals(type.getSchemaType())) {
            Type type2 = type.getTypeMapping().getType(overrideTypeName);
            if (type2 == null) {
                LOG.info((Object)("xsi:type=\"" + overrideTypeName + "\" was specified, but no corresponding Type was registered; defaulting to " + type.getSchemaType()));
            } else {
                type = type2;
            }
        }
        return type;
    }

    public void writeParameter(MessagePartInfo p, XMLStreamWriter writer, MessageContext context, Object value) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        type = AegisBindingProvider.getWriteType(context, value, type);
        ElementWriter mw = new ElementWriter(writer);
        if (type.isNillable() && value == null) {
            mw.writeXsiNil();
            return;
        }
        context.setProperty(CURRENT_MESSAGE_PART, (Object)p);
        type.writeObject(value, mw, context);
    }

    public static Type getWriteType(MessageContext context, Object value, Type type) {
        List l;
        if (value != null && type != null && type.getTypeClass() != value.getClass() && context.getService() != null && (l = (List)context.getService().getProperty(OVERRIDE_TYPES_KEY)) != null && l.contains(value.getClass().getName())) {
            type = type.getTypeMapping().getType(value.getClass());
        }
        return type;
    }

    public QName getSuggestedName(Service service, OperationInfo op, int param) {
        Type type;
        TypeMapping tm = this.getTypeMapping(service);
        QName name = tm.getTypeCreator().getElementName(op.getMethod(), param);
        if (name == null && (type = tm.getTypeCreator().createType(op.getMethod(), param)).isComplex() && !type.isAbstract()) {
            name = type.getSchemaType();
        }
        return name;
    }

    private Type getParameterType(TypeMapping tm, MessagePartInfo param, int paramtype) {
        Type type = tm.getType(param.getName());
        if (type == null) {
            type = (Type)this.part2type.get(param);
        }
        if (type == null) {
            OperationInfo op = param.getContainer().getOperation();
            type = paramtype != 2 ? tm.getTypeCreator().createType(op.getMethod(), param.getIndex()) : tm.getTypeCreator().createType(param.getTypeClass());
            type.setTypeMapping(tm);
            this.part2type.put(param, type);
        }
        return type;
    }

    public TypeMapping getTypeMapping(Service service) {
        TypeMapping tm = (TypeMapping)service.getProperty(TYPE_MAPPING_KEY);
        if (tm == null) {
            tm = this.createTypeMapping(service);
        }
        return tm;
    }

    protected TypeMapping createTypeMapping(Service endpoint) {
        String encodingStyle = (String)endpoint.getProperty(ENCODING_URI_KEY);
        if (encodingStyle == null) {
            encodingStyle = "http://www.w3.org/2001/XMLSchema";
        }
        endpoint.setProperty(ENCODING_URI_KEY, (Object)encodingStyle);
        TypeMapping tm = this.registry.createTypeMapping(encodingStyle, true);
        endpoint.setProperty(TYPE_MAPPING_KEY, (Object)tm);
        this.registry.register(endpoint.getName().getNamespaceURI(), tm);
        return tm;
    }

    public Class getTypeClass(QName name, Service service) {
        TypeMapping tm = service != null ? this.getTypeMapping(service) : this.registry.getDefaultTypeMapping();
        Type type = tm.getType(name);
        if (type == null) {
            return null;
        }
        return type.getTypeClass();
    }

    public SchemaType getSchemaType(QName name, Service service) {
        TypeMapping tm = service != null ? this.getTypeMapping(service) : this.registry.getDefaultTypeMapping();
        Type type = tm.getType(name);
        if (type == null) {
            ObjectType ot = new ObjectType();
            ot.setTypeMapping(tm);
            ot.setSchemaType(name);
            type = ot;
        }
        return type;
    }

    public Type getType(Service service, Class clazz) {
        TypeMapping tm = this.getTypeMapping(service);
        Type type = tm.getType(clazz);
        if (type == null) {
            type = tm.getTypeCreator().createType(clazz);
            tm.register(type);
        }
        return type;
    }
}

