/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.jsr181;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.io.File;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.jsr181.AbstractServiceGenerator;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;

public class ServiceStubGenerator
extends AbstractServiceGenerator {
    private static final Log log = LogFactory.getLog(ServiceStubGenerator.class);
    public static final String SERVICE_STUB = "service.stub";

    public void generate(GenerationContext context, Service service) throws Exception {
        if (service.getEndpoints().size() == 0 || !context.isServerStubGenerated()) {
            return;
        }
        super.generate(context, service);
    }

    protected boolean overwriteClass(GenerationContext context, Service service, String clsName, File classFile) {
        if (context.isServerStubOverwritten()) {
            return true;
        }
        try {
            JType type = context.getCodeModel().parseType(clsName);
            service.setProperty(SERVICE_STUB, (Object)type);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        log.info((Object)"Found a pre-existing server stub. It will not be overwritten.");
        return false;
    }

    protected String getClassName(GenerationContext context, Service service) {
        QName name = service.getName();
        String pckg = this.getPackage(service.getName(), context);
        String clsName = this.javify(name.getLocalPart());
        return this.getUniqueName(context.getCodeModel(), pckg + "." + clsName + "Impl");
    }

    protected void annotate(GenerationContext context, Service service, JDefinedClass jc) {
        super.annotate(context, service, jc);
        JAnnotationUse ann = jc.annotate(WebService.class);
        ann.param("serviceName", service.getSimpleName());
        ann.param("targetNamespace", service.getTargetNamespace());
        JClass intf = (JClass)service.getProperty("service.interface");
        ann.param("endpointInterface", intf.fullName());
        jc._implements(intf);
        service.setProperty(SERVICE_STUB, (Object)jc);
    }

    protected void annotate(GenerationContext context, OperationInfo op, JMethod method) {
        JType ex = context.getCodeModel()._ref(UnsupportedOperationException.class);
        method.body()._throw((JExpression)JExpr._new((JType)ex));
    }

    protected ClassType getClassType() {
        return ClassType.CLASS;
    }
}

