/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Bayeux;

public class ChannelId {
    public static final String WILD = "*";
    public static final String DEEPWILD = "**";
    private static final Pattern VAR = Pattern.compile("\\{(\\w+)\\}");
    private final ReentrantLock lock = new ReentrantLock();
    private final String _id;
    private volatile String[] _segments;
    private int _wild;
    private List<String> _wilds;
    private List<String> _all;
    private String _parent;
    private List<String> _vars;

    public ChannelId(String id) {
        if (id == null || id.length() == 0 || !Bayeux.Validator.isValidChannelId(id)) {
            throw new IllegalArgumentException("Invalid channel id: " + id);
        }
        if ((id = id.trim()).charAt(id.length() - 1) == '/') {
            id = id.substring(0, id.length() - 1);
        }
        this._id = id;
    }

    private void resolve() {
        if (this._segments == null) {
            this.lock.lock();
            try {
                if (this._segments == null) {
                    this.resolve(this._id);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void resolve(String name) {
        String[] segments = name.substring(1).split("/");
        if (segments.length < 1) {
            throw new IllegalArgumentException("Invalid channel id: " + String.valueOf(this));
        }
        int size = segments.length;
        for (int i = 1; i <= size; ++i) {
            String segment = segments[i - 1];
            if (i < size && (WILD.equals(segment) || DEEPWILD.equals(segment))) {
                throw new IllegalArgumentException("Invalid channel id: " + String.valueOf(this));
            }
            Matcher matcher = VAR.matcher(segment);
            if (matcher.matches()) {
                if (this._vars == null) {
                    this._vars = new ArrayList<String>();
                }
                this._vars.add(matcher.group(1));
            }
            if (i != size) continue;
            this._wild = DEEPWILD.equals(segment) ? 2 : (WILD.equals(segment) ? 1 : 0);
        }
        this._vars = this._vars == null ? List.of() : List.copyOf(this._vars);
        if (this._wild > 0 && !this._vars.isEmpty()) {
            throw new IllegalArgumentException("Invalid channel id: " + String.valueOf(this));
        }
        this._wilds = List.copyOf(this.resolveWilds(segments));
        ArrayList<String> all = new ArrayList<String>();
        all.add(this._id);
        all.addAll(this._wilds);
        this._all = List.copyOf(all);
        this._parent = segments.length == 1 ? null : name.substring(0, name.length() - segments[segments.length - 1].length() - 1);
        this._segments = segments;
    }

    private List<String> resolveWilds(String[] segments) {
        boolean addShallow = this._wild == 0;
        int length = this._wild > 1 ? segments.length - 1 : segments.length;
        ArrayList<String> wilds = new ArrayList<String>(length + 1);
        StringBuilder b = new StringBuilder("/");
        for (int i = 1; i <= length; ++i) {
            String segment = segments[i - 1];
            if (segment.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid channel id: " + String.valueOf(this));
            }
            wilds.add(0, String.valueOf(b) + DEEPWILD);
            if (VAR.matcher(segment).matches()) {
                addShallow = i == length;
                break;
            }
            if (i >= length) continue;
            b.append(segment).append('/');
        }
        if (addShallow) {
            wilds.add(0, String.valueOf(b) + WILD);
        }
        return wilds;
    }

    public String getId() {
        return this._id;
    }

    public boolean isWild() {
        this.resolve();
        return this._wild > 0;
    }

    public boolean isShallowWild() {
        return this.isWild() && !this.isDeepWild();
    }

    public boolean isDeepWild() {
        this.resolve();
        return this._wild > 1;
    }

    public boolean isMeta() {
        return ChannelId.isMeta(this._id);
    }

    public boolean isService() {
        return ChannelId.isService(this._id);
    }

    public boolean isBroadcast() {
        return ChannelId.isBroadcast(this._id);
    }

    public boolean isTemplate() {
        this.resolve();
        return !this._vars.isEmpty();
    }

    public List<String> getParameters() {
        this.resolve();
        return this._vars;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelId) {
            ChannelId that = (ChannelId)obj;
            return this._id.equals(that._id);
        }
        return false;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean matches(ChannelId channelId) {
        this.resolve();
        if (channelId.isWild()) {
            return this.equals(channelId);
        }
        switch (this._wild) {
            case 0: {
                return this.equals(channelId);
            }
            case 1: {
                if (channelId._segments.length != this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(channelId._segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (channelId._segments.length < this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(channelId._segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Invalid wild value " + this._wild + " for " + String.valueOf(this));
    }

    public Map<String, String> bind(ChannelId target) {
        if (!this.isTemplate() || target.isTemplate() || target.isWild() || this.depth() != target.depth()) {
            return Map.of();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < this._segments.length; ++i) {
            String thisSegment = this.getSegment(i);
            String thatSegment = target.getSegment(i);
            Matcher matcher = VAR.matcher(thisSegment);
            if (matcher.matches()) {
                result.put(matcher.group(1), thatSegment);
                continue;
            }
            if (thisSegment.equals(thatSegment)) continue;
            return Map.of();
        }
        return result;
    }

    public String toString() {
        return this.getId();
    }

    public int depth() {
        this.resolve();
        return this._segments.length;
    }

    public boolean isAncestorOf(ChannelId id) {
        this.resolve();
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isParentOf(ChannelId id) {
        this.resolve();
        if (this.isWild() || this.depth() != id.depth() - 1) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getParent() {
        this.resolve();
        return this._parent;
    }

    public String getSegment(int i) {
        this.resolve();
        if (i >= this._segments.length) {
            return null;
        }
        return this._segments[i];
    }

    @Deprecated
    public List<String> getWilds() {
        this.resolve();
        return this.isWild() ? List.of() : this._wilds;
    }

    public List<String> getWildIds() {
        this.resolve();
        return this._wilds;
    }

    public List<String> getAllIds() {
        this.resolve();
        return this._all;
    }

    public String getRegularPart() {
        this.resolve();
        if (this.isWild()) {
            return this.getParent();
        }
        if (!this.isTemplate()) {
            return this._id;
        }
        int regular = this.depth() - this.getParameters().size();
        if (regular <= 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < regular; ++i) {
            result.append("/").append(this.getSegment(i));
        }
        return result.toString();
    }

    public static boolean isMeta(String channelId) {
        return channelId != null && channelId.startsWith("/meta/");
    }

    public static boolean isService(String channelId) {
        return channelId != null && channelId.startsWith("/service/");
    }

    public static boolean isBroadcast(String channelId) {
        return !ChannelId.isMeta(channelId) && !ChannelId.isService(channelId);
    }
}

