/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.websocket.common;

import java.io.EOFException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketTransport
extends HttpClientTransport
implements MessageClientTransport {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String PERMESSAGE_DEFLATE_OPTION = "permessageDeflate";
    public static final String CONNECT_TIMEOUT_OPTION = "connectTimeout";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String STICKY_RECONNECT_OPTION = "stickyReconnect";
    public static final int MAX_CLOSE_REASON_LENGTH = 30;
    public static final int NORMAL_CLOSE_CODE = 1000;
    protected static final String COOKIE_HEADER = "Cookie";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebSocketTransport.class);
    private final AutoLock _lock = new AutoLock();
    private boolean _open;
    private String _protocol;
    private boolean _perMessageDeflate;
    private long _connectTimeout;
    private long _idleTimeout;
    private boolean _stickyReconnect;
    private Delegate _delegate;
    private TransportListener _listener;

    protected AbstractWebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler) {
        super(NAME, url, options, scheduler);
        this.setOptionPrefix(PREFIX);
    }

    public void setMessageTransportListener(TransportListener listener) {
        this._listener = listener;
    }

    public void setURL(String url) {
        super.setURL(url.replaceFirst("^http", PREFIX));
    }

    public void init() {
        super.init();
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._perMessageDeflate = this.getOption(PERMESSAGE_DEFLATE_OPTION, false);
        this.setMaxNetworkDelay(15000L);
        this._connectTimeout = 30000L;
        this._idleTimeout = 60000L;
        this._stickyReconnect = this.getOption(STICKY_RECONNECT_OPTION, true);
        this.locked(() -> {
            this._open = true;
            this.initScheduler();
        });
    }

    protected void locked(Runnable block) {
        this.locked(() -> {
            block.run();
            return null;
        });
    }

    protected <T> T locked(Supplier<T> block) {
        try (AutoLock ignored = this._lock.lock();){
            T t = block.get();
            return t;
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean isPerMessageDeflateEnabled() {
        return this._perMessageDeflate;
    }

    public long getIdleTimeout() {
        this._idleTimeout = this.getOption(IDLE_TIMEOUT_OPTION, this._idleTimeout);
        return this._idleTimeout;
    }

    public long getConnectTimeout() {
        this._connectTimeout = this.getOption(CONNECT_TIMEOUT_OPTION, this._connectTimeout);
        return this._connectTimeout;
    }

    public boolean isStickyReconnect() {
        return this._stickyReconnect;
    }

    public void abort(Throwable failure) {
        Delegate delegate = this.locked(() -> {
            this._open = false;
            this.shutdownScheduler();
            return this.getDelegate();
        });
        if (delegate != null) {
            delegate.abort(failure);
        }
    }

    public void terminate() {
        Delegate delegate = this.locked(() -> {
            this._open = false;
            this.shutdownScheduler();
            return this.getDelegate();
        });
        if (delegate != null) {
            delegate.terminate();
        }
        super.terminate();
    }

    protected Delegate getDelegate() {
        return this.locked(() -> this._delegate);
    }

    public void send(TransportListener listener, List<Message.Mutable> messages) {
        Delegate delegate = this.getDelegate();
        if (delegate == null) {
            String url = this.getURL();
            Delegate newDelegate = this.connect(url = url.replaceFirst("^http", PREFIX), listener, messages);
            if (newDelegate == null) {
                return;
            }
            delegate = this.locked(() -> {
                if (this._delegate == null) {
                    this._delegate = newDelegate;
                    return this._delegate;
                }
                newDelegate.shutdown("Extra");
                return this._delegate;
            });
        }
        try {
            delegate.registerMessages(listener, messages);
            String content = this.generateJSON(messages);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending messages {}", (Object)content);
            }
            listener.onSending(messages);
            delegate.send(content);
        }
        catch (Throwable x) {
            delegate.fail(x, "Exception");
        }
    }

    protected abstract Delegate connect(String var1, TransportListener var2, List<Message.Mutable> var3);

    protected abstract class Delegate {
        private final Map<String, WebSocketExchange> _exchanges = new ConcurrentHashMap<String, WebSocketExchange>();
        private boolean _connected;
        private boolean _disconnected;
        private Map<String, Object> _advice;

        protected Delegate() {
        }

        protected void onClose(int code, String reason) {
            if (this.detach()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closed websocket connection {}/{}", (Object)code, (Object)reason);
                }
                this.close();
                this.failMessages(new EOFException("Connection closed " + code + " " + reason));
            }
        }

        protected void onData(String data) {
            try {
                List messages = AbstractWebSocketTransport.this.parseMessages(data);
                if (this.isAttached()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received messages {}", (Object)data);
                    }
                    this.onMessages(messages);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Discarded messages {}", (Object)data);
                }
            }
            catch (ParseException x) {
                this.fail(x, "Exception");
            }
        }

        protected void onMessages(List<Message.Mutable> messages) {
            for (Message.Mutable message : messages) {
                if (this.isReply((Message)message)) {
                    WebSocketExchange exchange;
                    Map advice;
                    if ("/meta/connect".equals(message.getChannel()) && message.isSuccessful() && (advice = message.getAdvice()) != null && advice.get("timeout") != null) {
                        this._advice = advice;
                    }
                    if ((exchange = this.deregisterMessage((Message)message)) != null) {
                        exchange.listener.onMessages(new ArrayList<Message.Mutable>(List.of(message)));
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Could not find request for reply {}", (Object)message);
                    }
                    if (!this._disconnected || this._connected) continue;
                    this.disconnect("Disconnect");
                    continue;
                }
                AbstractWebSocketTransport.this._listener.onMessages(new ArrayList<Message.Mutable>(List.of(message)));
            }
        }

        private boolean isReply(Message message) {
            if (message.isPublishReply()) {
                return true;
            }
            if (message.isMeta()) {
                if ("/meta/disconnect".equals(message.getChannel())) {
                    return message.getId() != null;
                }
                return true;
            }
            return false;
        }

        protected void registerMessages(TransportListener listener, List<Message.Mutable> messages) {
            boolean open = AbstractWebSocketTransport.this.locked(() -> {
                if (this.isOpen()) {
                    for (Message.Mutable message : messages) {
                        this.registerMessage(message, listener);
                    }
                    return true;
                }
                return false;
            });
            if (!open) {
                listener.onFailure((Throwable)new IOException("Unconnected"), messages);
            }
        }

        private void registerMessage(Message.Mutable message, TransportListener listener) {
            WebSocketExchange existing;
            long maxNetworkDelay = AbstractWebSocketTransport.this.getMaxNetworkDelay();
            if ("/meta/connect".equals(message.getChannel())) {
                Map<String, Object> advice = message.getAdvice();
                if (advice == null) {
                    advice = this._advice;
                }
                if (advice != null) {
                    Object timeout = advice.get("timeout");
                    if (timeout instanceof Number) {
                        maxNetworkDelay += (long)((Number)timeout).intValue();
                    } else if (timeout != null) {
                        maxNetworkDelay += (long)Integer.parseInt(timeout.toString());
                    }
                }
                this._connected = true;
            }
            long delay = maxNetworkDelay;
            AtomicReference timeoutTaskRef = new AtomicReference();
            ScheduledFuture<?> newTask = AbstractWebSocketTransport.this.getScheduler().schedule(() -> this.onTimeout(listener, (Message)message, delay, timeoutTaskRef), maxNetworkDelay, TimeUnit.MILLISECONDS);
            timeoutTaskRef.set(newTask);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Started waiting for message reply, {} ms, task@{}", (Object)maxNetworkDelay, (Object)Integer.toHexString(newTask.hashCode()));
            }
            WebSocketExchange exchange = new WebSocketExchange(message, listener, timeoutTaskRef);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering {}", (Object)exchange);
            }
            if ((existing = this._exchanges.put(message.getId(), exchange)) != null) {
                throw new IllegalStateException("Could not register exchange " + String.valueOf(exchange) + ", existing exchange is " + String.valueOf(existing) + " for message " + String.valueOf(message));
            }
        }

        private void onTimeout(TransportListener listener, Message message, long delay, AtomicReference<ScheduledFuture<?>> timeoutTaskRef) {
            listener.onTimeout(List.of(message), Promise.from(result -> {
                if (result > 0L) {
                    ScheduledFuture<?> newTask = AbstractWebSocketTransport.this.getScheduler().schedule(() -> this.onTimeout(listener, message, delay + result, timeoutTaskRef), (long)result, TimeUnit.MILLISECONDS);
                    ScheduledFuture<?> oldTask = timeoutTaskRef.getAndSet(newTask);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extended waiting for message reply, {} ms, oldTask@{}, newTask@{}", new Object[]{result, Integer.toHexString(oldTask.hashCode()), Integer.toHexString(newTask.hashCode())});
                    }
                } else {
                    this.fail(new TimeoutException("Network delay expired: " + delay + " ms"), "Expired");
                }
            }, failure -> this.fail((Throwable)failure, "Failure")));
        }

        private WebSocketExchange deregisterMessage(Message message) {
            if ("/meta/connect".equals(message.getChannel())) {
                this._connected = false;
            } else if ("/meta/disconnect".equals(message.getChannel())) {
                this._disconnected = true;
            }
            WebSocketExchange exchange = null;
            String messageId = message.getId();
            if (messageId != null) {
                exchange = this._exchanges.remove(messageId);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deregistering {} for message {}", (Object)exchange, (Object)message);
            }
            if (exchange != null) {
                ScheduledFuture<?> task = exchange.taskRef.get();
                task.cancel(false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cancelled waiting for message replies, task@{}", (Object)Integer.toHexString(task.hashCode()));
                }
            }
            return exchange;
        }

        protected String trimCloseReason(String reason) {
            if (reason != null) {
                return reason.substring(0, Math.min(reason.length(), 30));
            }
            return null;
        }

        protected abstract void send(String var1);

        protected void fail(Throwable failure, String reason) {
            this.disconnect(reason);
            this.failMessages(failure);
        }

        protected void failMessages(Throwable cause) {
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            for (WebSocketExchange exchange : new ArrayList<WebSocketExchange>(this._exchanges.values())) {
                Message.Mutable message = exchange.message;
                if (this.deregisterMessage((Message)message) != exchange) continue;
                messages.add(message);
                exchange.listener.onFailure(cause, messages);
                messages.clear();
            }
        }

        private void abort(Throwable failure) {
            this.fail(failure, "Aborted");
        }

        private void disconnect(String reason) {
            if (this.detach()) {
                this.shutdown(reason);
            }
        }

        private boolean isAttached() {
            return AbstractWebSocketTransport.this.locked(() -> this == AbstractWebSocketTransport.this._delegate);
        }

        private boolean detach() {
            return AbstractWebSocketTransport.this.locked(() -> {
                boolean attached;
                boolean bl = attached = this == AbstractWebSocketTransport.this._delegate;
                if (attached) {
                    AbstractWebSocketTransport.this._delegate = null;
                }
                return attached;
            });
        }

        protected boolean isOpen() {
            return AbstractWebSocketTransport.this.locked(() -> AbstractWebSocketTransport.this._open);
        }

        protected abstract void close();

        protected abstract void shutdown(String var1);

        private void terminate() {
            this.fail(new EOFException(), "Terminate");
        }
    }

    private static class WebSocketExchange {
        private final Message.Mutable message;
        private final TransportListener listener;
        private final AtomicReference<ScheduledFuture<?>> taskRef;

        private WebSocketExchange(Message.Mutable message, TransportListener listener, AtomicReference<ScheduledFuture<?>> taskRef) {
            this.message = message;
            this.listener = listener;
            this.taskRef = taskRef;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + String.valueOf(this.message);
        }
    }
}

