/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.annotation.server.Configure;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.filter.DataFilter;
import org.cometd.server.filter.DataFilterMessageListener;
import org.cometd.server.filter.JSONDataFilter;
import org.cometd.server.filter.NoMarkupFilter;

@Service(value="chat")
public class ChatService {
    private final ConcurrentMap<String, Map<String, String>> _members = new ConcurrentHashMap<String, Map<String, String>>();
    @Inject
    private BayeuxServer _bayeux;
    @org.cometd.annotation.Session
    private ServerSession _session;

    @Configure(value={"/chat/**", "/members/**"})
    protected void configureChatStarStar(ConfigurableServerChannel channel) {
        DataFilterMessageListener noMarkup = new DataFilterMessageListener(new DataFilter[]{new NoMarkupFilter(), new BadWordFilter()});
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)noMarkup);
        channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
    }

    @Configure(value={"/service/members"})
    protected void configureMembers(ConfigurableServerChannel channel) {
        channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_PUBLISH);
        channel.setPersistent(true);
    }

    @Listener(value={"/service/members"})
    public void handleMembership(ServerSession client, ServerMessage message) {
        ConcurrentHashMap<String, String> new_room;
        Map data = message.getDataAsMap();
        String room = ((String)data.get("room")).substring("/chat/".length());
        ConcurrentHashMap<String, String> roomMembers = (ConcurrentHashMap<String, String>)this._members.get(room);
        if (roomMembers == null && (roomMembers = (Map)this._members.putIfAbsent(room, new_room = new ConcurrentHashMap<String, String>())) == null) {
            roomMembers = new_room;
        }
        ConcurrentHashMap<String, String> members = roomMembers;
        String userName = (String)data.get("user");
        members.put(userName, client.getId());
        client.addListener((ServerSession.ServerSessionListener)((ServerSession.RemovedListener)(s, m, t) -> {
            members.values().remove(s.getId());
            this.broadcastMembers(room, members.keySet());
        }));
        this.broadcastMembers(room, members.keySet());
    }

    private void broadcastMembers(String room, Set<String> members) {
        ClientSessionChannel channel = this._session.getLocalSession().getChannel("/members/" + room);
        channel.publish(members);
    }

    @Configure(value={"/service/privatechat"})
    protected void configurePrivateChat(ConfigurableServerChannel channel) {
        DataFilterMessageListener noMarkup = new DataFilterMessageListener(new DataFilter[]{new NoMarkupFilter(), new BadWordFilter()});
        channel.setPersistent(true);
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)noMarkup);
        channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_PUBLISH);
    }

    @Listener(value={"/service/privatechat"})
    public void privateChat(ServerSession client, ServerMessage message) {
        ConcurrentHashMap new_room;
        Map data = message.getDataAsMap();
        String room = ((String)data.get("room")).substring("/chat/".length());
        ConcurrentHashMap membersMap = (ConcurrentHashMap)this._members.get(room);
        if (membersMap == null && (membersMap = (Map)this._members.putIfAbsent(room, new_room = new ConcurrentHashMap())) == null) {
            membersMap = new_room;
        }
        String[] peerNames = ((String)data.get("peer")).split(",");
        ArrayList<ServerSession> peers = new ArrayList<ServerSession>(peerNames.length);
        for (String peerName : peerNames) {
            ServerSession peer;
            String peerId = (String)membersMap.get(peerName);
            if (peerId == null || (peer = this._bayeux.getSession(peerId)) == null) continue;
            peers.add(peer);
        }
        if (peers.size() > 0) {
            HashMap<String, String> chat = new HashMap<String, String>();
            String text = (String)data.get("chat");
            chat.put("chat", text);
            chat.put("user", (String)data.get("user"));
            chat.put("scope", "private");
            ServerMessage.Mutable forward = this._bayeux.newMessage();
            forward.setChannel("/chat/" + room);
            forward.setId(message.getId());
            forward.setData(chat);
            if (text.lastIndexOf("lazy") > 0) {
                forward.setLazy(true);
            }
            for (ServerSession peer : peers) {
                if (peer == client) continue;
                peer.deliver((Session)this._session, forward, Promise.noop());
            }
            client.deliver((Session)this._session, forward, Promise.noop());
        }
    }

    class BadWordFilter
    extends JSONDataFilter {
        BadWordFilter() {
        }

        protected Object filterString(ServerSession session, ServerChannel channel, String string) {
            if (string.contains("dang")) {
                throw new DataFilter.AbortException();
            }
            return string;
        }
    }
}

