/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.commonjava.cdi.util.weft.ContextSensitiveWeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Locker<K> {
    private Map<K, ReentrantLock> locks;

    public Locker() {
        this.locks = Collections.synchronizedMap(new ContextSensitiveWeakHashMap());
    }

    public Locker(Map<K, ReentrantLock> locks) {
        this.locks = Collections.synchronizedMap(locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T ifUnlocked(K key, Function<K, T> function, BiFunction<K, ReentrantLock, T> lockedFunction) {
        ReentrantLock lock = this.locks.computeIfAbsent(key, k -> new ReentrantLock());
        Boolean locked = false;
        try {
            locked = lock.tryLock();
            if (locked.booleanValue()) {
                T t = function.apply(key);
                return t;
            }
            T t = lockedFunction.apply(key, lock);
            return t;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public boolean waitForLock(long timeoutSeconds, ReentrantLock lock) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        boolean waitingLocked = false;
        try {
            waitingLocked = lock.tryLock(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted by other threads for waiting processing result: {}", (Object)e.getMessage());
        }
        return waitingLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lockAnd(K key, long timeoutSeconds, Function<K, T> function, BiFunction<K, ReentrantLock, Boolean> lockFailedFunction) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        ReentrantLock lock = this.locks.computeIfAbsent(key, k -> new ReentrantLock());
        Boolean retry = false;
        do {
            Boolean locked = false;
            try {
                locked = lock.tryLock(timeoutSeconds, TimeUnit.SECONDS);
                if (locked.booleanValue()) {
                    T t = function.apply(key);
                    return t;
                }
                retry = lockFailedFunction.apply(key, lock);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting for lock on key: {}", key);
            }
            finally {
                if (locked.booleanValue()) {
                    lock.unlock();
                }
            }
        } while (retry == Boolean.TRUE);
        return null;
    }
}

