/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleVersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;

public class SimpleProjectRef
implements ProjectRef {
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;

    public SimpleProjectRef(String groupId, String artifactId) {
        if (StringUtils.isEmpty((String)groupId) || StringUtils.isEmpty((String)artifactId)) {
            throw new InvalidRefException("ProjectId must contain non-empty groupId AND artifactId. (Given: '" + groupId + "':'" + artifactId + "')", new Object[0]);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public <T extends ProjectRef> SimpleProjectRef(ProjectRef ref) {
        this.groupId = ref.getGroupId();
        this.artifactId = ref.getArtifactId();
    }

    public static ProjectRef parse(String ga) {
        String[] parts = ga.split(":");
        if (parts.length < 2 || StringUtils.isEmpty((String)parts[0]) || StringUtils.isEmpty((String)parts[1])) {
            throw new InvalidRefException("ProjectRef must contain non-empty groupId AND artifactId. (Given: '" + ga + "')", new Object[0]);
        }
        return new SimpleProjectRef(parts[0], parts[1]);
    }

    @Override
    public final String getGroupId() {
        return this.groupId;
    }

    @Override
    public final String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public ProjectRef asProjectRef() {
        return SimpleProjectRef.class.equals(this.getClass()) ? this : new SimpleProjectRef(this.getGroupId(), this.getArtifactId());
    }

    @Override
    public VersionlessArtifactRef asVersionlessPomArtifact() {
        return this.asVersionlessArtifactRef("pom", null);
    }

    @Override
    public VersionlessArtifactRef asVersionlessJarArtifact() {
        return this.asVersionlessArtifactRef("jar", null);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(String type, String classifier) {
        return new SimpleVersionlessArtifactRef(this, type, classifier);
    }

    @Override
    public VersionlessArtifactRef asVersionlessArtifactRef(TypeAndClassifier tc) {
        return new SimpleVersionlessArtifactRef(this, tc);
    }

    public String toString() {
        return String.format("%s:%s", this.groupId, this.artifactId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectRef)) {
            return false;
        }
        ProjectRef other = (ProjectRef)obj;
        if (!this.artifactId.equals(other.getArtifactId())) {
            return false;
        }
        return this.groupId.equals(other.getGroupId());
    }

    @Override
    public int compareTo(ProjectRef o) {
        int comp = this.groupId.compareTo(o.getGroupId());
        if (comp == 0) {
            comp = this.artifactId.compareTo(o.getArtifactId());
        }
        return comp;
    }

    @Override
    public boolean matches(ProjectRef ref) {
        if (this.equals(ref)) {
            return true;
        }
        String gidPattern = this.toWildcard(this.getGroupId());
        if (!ref.getGroupId().matches(gidPattern)) {
            return false;
        }
        String aidPattern = this.toWildcard(this.getArtifactId());
        return ref.getArtifactId().matches(aidPattern);
    }

    private String toWildcard(String val) {
        return val.replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
    }
}

