/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;
import org.commonjava.maven.atlas.ident.util.VersionUtils;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;

public class SimpleProjectVersionRef
extends SimpleProjectRef
implements ProjectVersionRef {
    private static final long serialVersionUID = 1L;
    private VersionSpec versionSpec;
    private String versionString;

    public SimpleProjectVersionRef(ProjectRef ref, VersionSpec versionSpec) {
        this(ref.getGroupId(), ref.getArtifactId(), versionSpec, null);
    }

    public SimpleProjectVersionRef(ProjectRef ref, String versionSpec) throws InvalidVersionSpecificationException {
        this(ref.getGroupId(), ref.getArtifactId(), versionSpec);
    }

    SimpleProjectVersionRef(String groupId, String artifactId, VersionSpec versionSpec, String versionString) {
        super(groupId, artifactId);
        if (versionSpec == null && StringUtils.isEmpty((String)versionString)) {
            throw new InvalidRefException("Version spec AND string cannot both be empty for '" + groupId + ":" + artifactId + "'", new Object[0]);
        }
        this.versionString = versionString;
        this.versionSpec = versionSpec;
    }

    public SimpleProjectVersionRef(String groupId, String artifactId, VersionSpec versionSpec) {
        this(groupId, artifactId, versionSpec, null);
    }

    public SimpleProjectVersionRef(String groupId, String artifactId, String versionString) throws InvalidVersionSpecificationException {
        this(groupId, artifactId, null, versionString);
    }

    public <T extends ProjectVersionRef> SimpleProjectVersionRef(ProjectVersionRef ref) {
        super(ref);
        this.versionSpec = ref.getVersionSpecRaw();
        this.versionString = ref.getVersionStringRaw();
    }

    public static ProjectVersionRef parse(String gav) {
        String[] parts = gav.split(":");
        if (parts.length < 3 || StringUtils.isEmpty((String)parts[0]) || StringUtils.isEmpty((String)parts[1]) || StringUtils.isEmpty((String)parts[2])) {
            throw new InvalidRefException("ProjectVersionRef must contain non-empty groupId, artifactId, AND version. (Given: '" + gav + "')", new Object[0]);
        }
        return new SimpleProjectVersionRef(parts[0], parts[1], parts[2]);
    }

    @Override
    public SimpleProjectVersionRef asProjectVersionRef() {
        return SimpleProjectVersionRef.class.equals(this.getClass()) ? this : new SimpleProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersionSpecRaw(), this.getVersionStringRaw());
    }

    @Override
    public ArtifactRef asPomArtifact() {
        return this.asArtifactRef("pom", null);
    }

    @Override
    public ArtifactRef asJarArtifact() {
        return this.asArtifactRef("jar", null);
    }

    @Override
    public ArtifactRef asArtifactRef(String type, String classifier) {
        return new SimpleArtifactRef(this, type, classifier);
    }

    @Override
    public ArtifactRef asArtifactRef(TypeAndClassifier tc) {
        return new SimpleArtifactRef(this, tc);
    }

    @Override
    public VersionSpec getVersionSpecRaw() {
        return this.versionSpec;
    }

    @Override
    public String getVersionStringRaw() {
        return this.versionString;
    }

    @Override
    public boolean isRelease() {
        return this.getVersionSpec().isRelease();
    }

    @Override
    public boolean isSpecificVersion() {
        return this.getVersionSpec().isSingle();
    }

    @Override
    public boolean matchesVersion(SingleVersion version) {
        return this.getVersionSpec().contains(version);
    }

    @Override
    public SimpleProjectVersionRef selectVersion(String version) {
        SingleVersion single = VersionUtils.createSingleVersion(version);
        return this.selectVersion(single, false);
    }

    @Override
    public SimpleProjectVersionRef selectVersion(String version, boolean force) {
        SingleVersion single = VersionUtils.createSingleVersion(version);
        return this.selectVersion(single, force);
    }

    @Override
    public SimpleProjectVersionRef selectVersion(SingleVersion version) {
        return this.selectVersion(version, false);
    }

    @Override
    public SimpleProjectVersionRef selectVersion(SingleVersion version, boolean force) {
        VersionSpec versionSpec = this.getVersionSpec();
        if (versionSpec.equals(version)) {
            return this;
        }
        if (!force && !versionSpec.contains(version)) {
            throw new IllegalArgumentException("Specified version: " + version.renderStandard() + " is not contained in spec: " + versionSpec.renderStandard());
        }
        return this.newRef(this.getGroupId(), this.getArtifactId(), version);
    }

    @Override
    public SimpleProjectVersionRef newRef(String groupId, String artifactId, SingleVersion version) {
        return new SimpleProjectVersionRef(groupId, artifactId, version);
    }

    @Override
    public VersionSpec getVersionSpec() {
        if (this.versionSpec == null) {
            this.versionSpec = VersionUtils.createFromSpec(this.versionString);
        }
        return this.versionSpec;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getVersionString() == null ? 0 : this.getVersionString().hashCode());
        return result;
    }

    @Override
    public boolean versionlessEquals(ProjectVersionRef other) {
        return this == other || super.equals(other);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        block11: {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ProjectVersionRef)) {
                return false;
            }
            ProjectVersionRef other = (ProjectVersionRef)obj;
            result = true;
            try {
                if (this.getVersionSpec() == null) {
                    if (other.getVersionSpec() != null) {
                        result = false;
                    }
                } else if (!this.getVersionSpec().equals(other.getVersionSpec())) {
                    result = false;
                }
            }
            catch (InvalidVersionSpecificationException e) {
                if (this.getVersionString() == null) {
                    if (other.getVersionString() != null) {
                        result = false;
                    }
                }
                if (this.getVersionString().equals(other.getVersionString())) break block11;
                result = false;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getVersionString());
    }

    @Override
    public boolean isCompound() {
        return !this.getVersionSpec().isSingle();
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersionSpec().isSnapshot();
    }

    @Override
    public String getVersionString() {
        if (this.versionString == null) {
            this.versionString = this.versionSpec.renderStandard();
        }
        return this.versionString;
    }

    @Override
    public boolean isVariableVersion() {
        return this.isCompound() || this.isSpecificVersion() && ((SingleVersion)this.getVersionSpec()).isLocalSnapshot();
    }

    @Override
    public int compareTo(ProjectRef o) {
        int comp = super.compareTo(o);
        if (comp == 0 && o instanceof ProjectVersionRef) {
            ProjectVersionRef or = (ProjectVersionRef)o;
            comp = this.getVersionString().compareTo(or.getVersionString());
        }
        return comp;
    }
}

