/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.ref;

import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;

public class SimpleTypeAndClassifier
implements TypeAndClassifier {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String classifier;

    public SimpleTypeAndClassifier(String type, String classifier) {
        this.type = type == null ? "jar" : type;
        this.classifier = StringUtils.isEmpty((String)classifier) ? null : classifier;
    }

    public SimpleTypeAndClassifier(String type) {
        this(type, null);
    }

    public SimpleTypeAndClassifier() {
        this(null, null);
    }

    public <T extends TypeAndClassifier> SimpleTypeAndClassifier(TypeAndClassifier typeAndClassifier) {
        this.type = typeAndClassifier.getType();
        this.classifier = typeAndClassifier.getClassifier();
    }

    @Override
    public String getType() {
        return this.type == null ? "jar" : this.type;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        return String.format("%s%s", this.type, this.classifier == null ? "" : ":" + this.classifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeAndClassifier)) {
            return false;
        }
        TypeAndClassifier other = (TypeAndClassifier)obj;
        if (this.classifier == null ? other.getClassifier() != null : !this.classifier.equals(other.getClassifier())) {
            return false;
        }
        return !(this.type == null ? other.getType() != null : !this.type.equals(other.getType()));
    }
}

