/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.graph.rel;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.commonjava.maven.atlas.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.maven.atlas.graph.rel.PluginRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;

public final class SimplePluginRelationship
extends AbstractSimpleProjectRelationship<PluginRelationship, ProjectVersionRef>
implements Serializable,
PluginRelationship {
    private static final long serialVersionUID = 1L;
    private final boolean reporting;

    public SimplePluginRelationship(URI source, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean managed, boolean inherited) {
        this(source, declaring, target, index, managed, false, inherited);
    }

    public SimplePluginRelationship(URI source, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean managed, boolean reporting, boolean inherited) {
        super(source, RelationshipType.PLUGIN, declaring, target, index, managed, inherited, false);
        this.reporting = reporting;
    }

    public SimplePluginRelationship(URI source, URI pomLocation, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean managed, boolean inherited) {
        this(source, pomLocation, declaring, target, index, managed, false, inherited);
    }

    public SimplePluginRelationship(URI source, URI pomLocation, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean managed, boolean reporting, boolean inherited) {
        super(source, pomLocation, RelationshipType.PLUGIN, declaring, target, index, managed, inherited, false);
        this.reporting = reporting;
    }

    public SimplePluginRelationship(Collection<URI> sources, URI pomLocation, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean managed, boolean reporting, boolean inherited) {
        super(sources, pomLocation, RelationshipType.PLUGIN, declaring, target, index, managed, inherited, false);
        this.reporting = reporting;
    }

    public SimplePluginRelationship(PluginRelationship relationship) {
        super(relationship);
        this.reporting = relationship.isReporting();
    }

    @Override
    public final boolean isReporting() {
        return this.reporting;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isManaged() ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PluginRelationship)) {
            return false;
        }
        PluginRelationship other = (PluginRelationship)obj;
        return this.isManaged() == other.isManaged();
    }

    public String toString() {
        return String.format("PluginRelationship [%s => %s (managed=%s, index=%s)]", this.getDeclaring(), this.getTarget(), this.isManaged(), this.getIndex());
    }

    @Override
    protected ProjectVersionRef cloneTarget(ProjectVersionRef target) {
        return new SimpleProjectVersionRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return new SimpleArtifactRef(this.getTarget(), "maven-plugin", null);
    }

    @Override
    public PluginRelationship selectDeclaring(ProjectVersionRef ref) {
        Object t = this.getTarget();
        return new SimplePluginRelationship((Collection<URI>)this.getSources(), this.getPomLocation(), ref, (ProjectVersionRef)t, this.getIndex(), this.isManaged(), this.isReporting(), this.isInherited());
    }

    @Override
    public PluginRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        return new SimplePluginRelationship(this.getSources(), this.getPomLocation(), d, ref, this.getIndex(), this.isManaged(), this.isReporting(), this.isInherited());
    }

    @Override
    public synchronized PluginRelationship cloneFor(ProjectVersionRef projectRef) {
        return new SimplePluginRelationship((Collection<URI>)this.getSources(), this.getPomLocation(), projectRef, (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isManaged(), this.reporting, this.isInherited());
    }

    @Override
    public PluginRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimplePluginRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isManaged(), this.reporting, this.isInherited());
    }

    @Override
    public PluginRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimplePluginRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isManaged(), this.reporting, this.isInherited());
    }
}

